*-------------------------------------------------------
*   random3
*   to generate 3-D center points
*   - with anticorrelation
*   - Poisson
*   cube of 1x1x1
*-------------------------------------------------------

	dimension x(10000), y(10000), z(10000)
	character bfile*40, header*132

	DATA LBYTE,maxpt/132,10000/

	DATA nlist,ncard,iunit/6,5,1/

*--- input-----------------------------------------------

	write(nlist,9001)
9001	format(
     .   ' -------------------------------------------------------'/
     .   '  random3 (for MacOSX) generates 3-D points'/
     .   '  x-y-z coordinates are stored in text file'/
     .   ' -------------------------------------------------------')

10001	write(nlist,1001) maxpt
1001	format(' Max.no. of points = ',i5/' No.of points ? >')
	read(ncard,*,ERR=10001) npoints

	if(npoints.le.maxpt) go to 1

	write(nlist,1002) maxpt
1002	format(' No. of points is set to ',I4)
	npoints=maxpt

1	continue


*--- scaling -----------------------------------------------

*	write(nlist,1030) npoints
*1030	format(' No. of particles for scaling (default = ', i4,') ? > ')
*	read(ncard,'(i5)') npasc
*	if (npasc.le.0) npasc = npoints
	npasc = npoints

	I1=0
	I2=0
	i3=0


*--- starter numbers -----------------------------------------------

10002	write(nlist,1004)
1004	format(' 3 start numbers (1 to 10) for random number generator'/
     .        ' Input 3 integers ("x,y,z") > ')
	read(ncard,*,ERR=10002) loopx,loopy,loopz


*--- minimal distance -----------------------------------------------

10004	write(nlist,1006)
1006	format(' Min.distance between center points (w/r to size)'/
     .        ' (possible values: 0.-1.00) > ')
	read(ncard,*,ERR=10004) fdist
3	continue


*--- isotropy -----------------------------------------------

10005	write(nlist,1007)
1007	format(' Isotropic or anisotropic positioning ? iso=1,'/
     .        ' (aniso=0 > ')
	read(ncard,*,ERR=10005) NISO

	IF(NISO.EQ.1) GO TO 4
	write(nlist,1008)
1008	format(' Ratio of anticorrelating distances of centerpoints'/
     .        ' z-direction./xy-plane > ')
	read(ncard,*,ERR=10005) FAXR
	AXz= SQRT(FAXR)
	AXxy= 1./AXz
4	continue


*--- start -----------------------------------------------



*--- anticlustered center points -----------------------------------------------


11	continue
	xlog=log(float(npasc))
	DIST= FDIST/2.718281828459**(xlog/3.)
*	print *,'fdist =',fdist
*	print *,'xlog =',xlog
*	print *,'dist =',dist

	do 201 ii=1,npoints

202	continue

	do k=1,loopx
	CALL RANDU(I1,I1,X(II))
	enddo
	do k=1,loopy
	CALL RANDU(I2,I2,Y(II))
	enddo
	do k=1,loopz
	call randu(i3,i3,z(ii))
	enddo

*	IF(NISO.EQ.0) THEN
*	X(II)=X(II)*AXxy
*	Y(II)=Y(II)*AXxy
*	z(ii)=z(ii)*axz
*	ENDIF

204	continue

	IF(II.EQ.1) GO TO 201

	DO 205 III= 1,II-1
	XD= X(II)-X(III)
	YD= Y(II)-Y(III)
	zd= z(ii)-z(iii)
	D= SQRT(XD*XD+YD*YD+zd*zd)
	IF(D.LT.DIST)  GO TO 202
205	continue

201	continue

*	DO 206 I=1,npoitns
*	X(I)= RX(I)
*	Y(I)= RY(I)
*	z(i)= rz(i)
*206	continue

12	continue
C
C   ANISOTROPIC CENTER POINTS
C
	IF(NISO.EQ.1) GO TO 13
	DO 215 IS=1,npoints
	X(IS)= X(IS)*AXxy
	Y(IS)= Y(IS)*AXxy
	z(is)= z(is)*axz
215	continue
13	continue



*--- open file -----------------------------------------------


10010	write (nlist,1020)
1020   format(' Name of file > ')
	read(ncard,5002,ERR=10010) bfile
5002	FORMAT(A)


	write(nlist,1021) LBYTE
1021	format(' Header (Maximum length = ',I3,' characters) > ')
	read(ncard,5002,ERR=10010) BTIT

	open(unit=iunit, file=bfile,status='new',
     .      form='formatted', access='sequential')

	write(iunit,7001) BTIT
7001	format(A)

	write(iunit,*) npoints



	write(nlist,9990)
9990	format(/' File will be saved with x, y, z')

	DO 266 i=1,npoints
	write(iunit,'(3f8.3,i6)') x(i),y(i),z(i),i
266	continue


*--- close file -----------------------------------------------

	CLOSE(UNIT=iunit)
	END

*--- end -----------------------------------------------

C
C**********************************************************
C
	SUBROUTINE RANDU(I1,I2,R)
	
	R=RAND(I1)
	RETURN
	END
