*--------------------------------------------------------------------72
c
c   random
c
*--------------------------------------------------------------------72
c
c   random: generates pattern of random ellipses.
c   maxell (=1000) ellipses of maxpte (=370) points each.
c   the user has to indicate:
c   - orientation
c   - size
c   - location
c   - axial ratio
c   - neighbour distance
c   - shape (ellipse, rhombus, rectangle) of outlines
c
c   for grain size plot use randomgs
c
c
       program random

       dimension x(1000), y(1000), rx(1000), ry(1000)
       dimension xe(370), ye(370)
       dimension saxi(2),taxi(3),slen(2),tlen(3)
       character bfil*40, btit*132
       data pi,deg01,degrad/3.14159,0.00555555,0.01745/
       data lbyte,maxell,maxpte,nplus/132,1000,370,2/
       data xend,ixend/99999.,99999/
       data nlist,ncard,iunit/6,5,1/
*--------------------------------------------------------------------72
c   prime random number generator
       xdummy=rand(0)

*--------------------------------------------------------------------72
c   ask size of file
c
       write(nlist,9001) ixend, maxell, maxpte
9001   format(
     .   ' -------------------------------------------------------'/
     .   '  this is RANDOM                             24-aug-2010'/
     .   '  the program generates synthetic particle fabrics'/
     .   '  strings of x-y coordinates are saved in formatted file'/
     .   '  separator coordinate is',i6/
     .   '  max. no. of ellipses = ',i5,'  max. no. of pts. = ',i5/
     .   ' -------------------------------------------------------')
10001  write(nlist,1001) 
1001   format(' no. of ellipses, no. of pts./ellipse > ')
       read(ncard,*,err=10001) nell,npte
       if(npte.le.2) nplus= 1
       if(nell.le.maxell) go to 1
       write(nlist,1002) maxell
1002   format(' no. of ellipses is set to ',i4)
       nell= maxell
1      continue
       if(npte.lt.maxpte) go to 2
       write(nlist,1003) maxpte
1003   format(' no. of points/ellipse is set to ',i3)
       npte= maxpte
2      continue
c
c   scaling option via particle number
c
       write(nlist,1030) nell
1030   format
     . (' no. of particles for scaling (default = ', i4,') ? > ')
       read(ncard,'(i5)') npasc
       if (npasc.le.0) npasc = nell
       itotal= nell*(npte+nplus)
       xkante= sqrt(float(npasc))  !! =sqrt(float(nell))
       kante= ifix(xkante+.9)
       xint= 1./xkante
       xinc= 2.*pi/float(npte)
       xe(npte+nplus)= xend
       ye(npte+nplus)= xend
c
c   formats
c
5002   format(a)
*--------------------------------------------------------------------72
c   parameter input
c
10002  write(nlist,1004)
1004   format
     . (' 4 start numbers (1 to 10) for random number generator'/
     .        ' input four integers ("a,b,c,d") > ')
       read(ncard,*,err=10002) loopl, loopo, loops, loopx
c
c   location
c
10003  write(nlist,1005)
1005   format(' specify the spatial distribution of the particles:'/
     .      ' random position (1) or position on grid (0)  > ')
       read(ncard,*,err=10003) ncor
       if(ncor.eq.0) go to 3
10004  write(nlist,1006)
1006   format(' min.distance between center points (w/r to size)'/
     .        ' (possible values: 0.-1.00) > ')
       read(ncard,*,err=10004) fdist
3      continue
c
c   isotropic center points
c
10005  write(nlist,1007)
1007   format
     . (' isotropic or anisotropic positioning ? iso=1, aniso=0 > ')
       read(ncard,*,err=10005) niso
       if(niso.eq.1) go to 4
       write(nlist,1008)
1008   format(' ratio of anticorrelating distances of centerpoints'/
     .        ' y-direction./x-direction. > ')
       read(ncard,*,err=10005) faxr
       axy= sqrt(faxr)
       axx= 1./axy
4      continue
c
c   orientation of long axes
c
10006  write(nlist,1009)
1009   format
     . (' type of orientation distribution (ODF) of long axes ?'/
     . ' 1: ODF=uniform (random), 0: ODF=normal (pref. or.),'/
     . '-1: ODF=delta function (parallel), 2: manual input')
       read(ncard,*,err=10006) nori
       if(nori.ge.1) go to 5
       if(nori.eq.0) go to 6
       write(nlist,1010)
1010   format
     . (' orientation of long axes in degree (cclw, 0=east) ? > ')
       read(ncard,*,err=10006) angl
       angle= degrad*angl
       go to 5
6      continue
       write(nlist,1011)
1011   format(' mean and standard deviation (degrees) > ')
       read(ncard,*,err=10006) xmo, sgo
       xmo= xmo*deg01
       sgo= sgo*deg01
5      continue
c
c   length of long axes
c
10007  write(nlist,1012)
1012   format(' type of size distribution (h(a)) of long axes'/
     . ' 1: h(a)=uniform (all sizes), 0: h(a)=normal (pref. size),'/
     . '-1: h(a)=delta function (only one size) > ')
       read(ncard,*,err=10007) nlen
       if(nlen.eq.1) go to 7
       if(nlen.eq.0) go to 8
       write(nlist,1013)
1013   format
     . (' length of long axes in rel.units (values: 0.-1.00) > ')
       read(ncard,*,err=10007) flen
       go to 7
8      continue
       write(nlist,2011)
2011   format(' mean and standard deviation long axis (0.-1.) > ')

       read(ncard,*,err=10007) xms,sgs
7      continue
c
c   axial ratios
c
10008  write(nlist,1014)
1014   format(' type of distribution function of axial ratio b/a'/
     . ' 1: h(b/a)=uniform (all), 0: h(b/a)=normal (pref.ratio),'/
     . '-1: h(b/a)=delta function (only one ratio) > ')
       read(ncard,*,err=10008) naxi
       if(naxi.eq.1) go to 9
       if(naxi.eq.0) go to 10
       write(nlist,1015)
1015   format(' axial ratio (possible values: 0.-1.00) > ')
       read(ncard,*,err=10008) axi
       go to 9
10     continue
       write(nlist,3011)
3011   format(' mean and standard deviation b/a (0.-1.00) > ')
       read(ncard,*,err=10008) xmx, sgx
9      continue
       iv= 0
c
c   shapes
c
10009  write(nlist,1017)
1017   format
     . (' exact shape ? (0.= rectangle, 1.= ellipse, 2.= rhomb)' )
       read(ncard,*,err=10009) expt
c
c
*--------------------------------------------------------------------72
c        start 
c
c   location:  regular grid
c
       if(ncor.ne.0) go to 11
       do 200 ity= 1,kante
       do 200 itx= 1,kante
       iv= iv+1
       x(iv)= xint* float(itx)
       y(iv)= xint* float(ity)
200    continue
       go to 12
c
c   random anticlustered center points
c
11     continue
       dist= fdist*xint
       do 201 ii=1,nell
202    continue

       do 204 kl=1,loopl
       rx(ii)=rand(0)
       ry(ii)=rand(0)
       if(niso.eq.0) then
       rx(ii)=rx(ii)*axy
       ry(ii)=ry(ii)*axx
       endif
204    continue

       if(ii.eq.1) go to 201
       do 205 iii= 1,ii-1
       xd= rx(ii)-rx(iii)
       yd= ry(ii)-ry(iii)
       d= sqrt(xd*xd+yd*yd)
       if(d.lt.dist) go to 202
205    continue
201    continue
       do 206 i=1,nell
       x(i)= rx(i)
       y(i)= ry(i)
206    continue
12     continue
*--------------------------------------------------------------------72
c   anisotropic center points
c
       if(niso.eq.1) go to 13
       do 215 is=1,nell
       x(is)= x(is)*axx
       y(is)= y(is)*axy
215    continue
13     continue
*--------------------------------------------------------------------72
c   ellipses: size, axial ratios
c
       do 220 la=1,2
       saxi(la)=0.
       slen(la)=0.
220    continue
       i1=0
       i2=0
*--------------------------------------------------------------------72
c   length of long axes rx(..)
c
       do 240 i=1,nell
       rx(i)= flen
       ry(i)= axi
       if(nlen.eq.-1) go to 230
       if(nlen.eq.0) go to 243
*--------------------------------------------------------------------72
c   random length
c
       do 231 kl=1,loops
       rx(i)=rand(0)
231    continue
       go to 230
*--------------------------------------------------------------------72
c   normal distribution of length
c
243    continue
       do 245 kl=1,loops
       call chance(xms,sgs,rx(i))
245    continue
230    continue
*--------------------------------------------------------------------72
c   axial ratios  ry(..)
c
       if(naxi.eq.-1) go to 252
       if(naxi.eq.0)  go to 253
*--------------------------------------------------------------------72
c   random axial ratios
c
       do 250 kl=1,loopx
       ry(i)=rand(0)
250    continue
       go to 252
*--------------------------------------------------------------------72
c    normal distribution of axial ratios
c
253    continue
       do 255 kl=1,loopx
       call chance(xmx,sgx,ry(i))
255    continue
*--------------------------------------------------------------------72
c   statistics
c
252    continue

       
240    continue

*--------------------------------------------------------------------72
c   open file 
c

10010  write (nlist,1020)
1020    format(' name of file > ')
       read(ncard,5002,err=10010) bfil


       write(nlist,1021) lbyte
1021   format(' header (maximum length = ',i3,' characters) > ')
       read(ncard,5002,err=10010) btit

       open(unit=iunit, file=bfil,status='new',
     .      form='formatted', access='sequential')

       write(iunit,7001) btit
       write(iunit,*) itotal
7001   format(a)
c
       write(nlist,9990)
9990   format(/' file will be saved as formatted file;'/
     .          ' = input for surfor, paror, shapes, etc.'/)
*--------------------------------------------------------------------72
c   create ellipses, determine orientation
c
       do 260 i=1,nell
       xl= 0.5*xint*rx(i)
c
c   random orientation
c
       if(nori.ne.1) go to 262
       do 261 kl=1,loopo
       a=rand(0)
       angle= a*pi
261    continue
262    continue
       if(nori.ne.0) go to 263
       do 264 kl=1,loopo
       call chance(xmo,sgo,a)
       angle= a*pi
264    continue
263    continue
*--------------------------------------------------------------------72
c   normal distribution of orientation
c
       if(nori.ne.2) go to 265
10011  write(nlist,1023) i
1023   format(' orientation of ellipse no.',i3,' (degrees) > ')
       read(ncard,*,err=10011) angl
       angle= degrad*angl
265    continue


       call ell(xinc,npte,x(i),y(i),xl,ry(i),angle,xe(1),ye(1),expt)
       
       
       do 266 jj=1,npte+nplus
       write(iunit,*) xe(jj),ye(jj)
266    continue
260    continue
c
c   end loop
c
*--------------------------------------------------------------------72
c
       close(unit=iunit)
       end
c
*--------------------------------------------------------------------72
c   subroutine ell
c
       subroutine ell(xinc,npte,xc,yc,xl,ax,ang,x,y,expt)
c
c    calculates coordinates along perimeter of ellipse
c
       dimension x(1), y(1)
       nloop= 1
       if(npte.le.2) nloop= 0
       if(expt.eq.0.) expt=0.00001
       do 10 i=1,npte+nloop
c      do 10 i=1,npte
       xx= xl
       yy= xl*ax
       alf= float(i-1)*xinc
       co= cos(alf)
       si= sin(alf)
       coa= abs(co)
       sia= abs(si)
       xx= xl*coa**expt
       yy= xl*ax*sia**expt
       if(co.lt.0.) xx=-xx
       if(si.lt.0.) yy=-yy
       call rotxz(xx,yy,ang)
       x(i)= xx + xc
       y(i)= yy + yc
10     continue
       if(npte.le.2) go to 20
       x(npte+1)=x(1)
       y(npte+1)=y(1)
20     continue
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine rotxz
c
       subroutine rotxz(vect1,vect2,rad)
c
c   rotation of x/y vector about z axis (angle in radian)
c   anticlockwise rotation of vector
c   = clockwise rotation of axes when looking down third axis
c
       vh1=  vect1*cos(rad) - vect2*sin(rad)
       vh2=  vect1*sin(rad) + vect2*cos(rad)
       vect1= vh1
       vect2= vh2
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine chance
c
       subroutine chance (xquer, sigma, r)
c
c    calculates normally distributed pseudorandom numbers
c
c   r      real     output        pseudorandom number (0<r<1)
c   xquer  real     input         mean
c   sigma  real     input         standard deviation
c
       rsum = 0.
       do 70 i = 1,12
       rz=rand(0)
  70    rsum = rsum + rz
       r = (rsum - 6.) * sigma + xquer
       return
       end
c
