*--------------------------------------------------------------------72
c
c   monte carlo simulations for grain size distributions
c
*--------------------------------------------------------------------72
c   correct sampling of r and s
c   update 20.7.95 for decent output file
c   23.7.95 random generator for any distribution
*   update 2010 - jan - 25
c
c   d       distance
c   r       radius of sphere
c   s       sectional radius
c   st1*    matrix of moments (in): st1r for radii of spheres
c                                   st1s for radii of sectional circles
c   st2*    matrix of moments (out)
c   sst***  "superstatistics": statistics of statistical parameters of 
c                              samples
c                              *****0: number
c                              *****1: mean
c                              *****2: variance
c                              *****3: standard deviation
c                              *****4: skewness
c

       program montecarloD
       
       dimension st1r(3),st2r(4),st1s(3),st2s(4)
       dimension sst1r1(3),sst2r1(4),sst1s1(3),sst2s1(4)
       dimension sst1r0(3),sst2r0(4),sst1s0(3),sst2s0(4)
       dimension sst1r3(3),sst2r3(4),sst1s3(3),sst2s3(4)
       dimension sst1r4(3),sst2r4(4),sst1s4(3),sst2s4(4)
       dimension dstb(101)
       character*60 bfil,distrib,bstats,bradR,bradS
       data nlist,ncard,iunit1,iunit2,iunit3/6,5,1,2,3/
c
c   dmax scales input to interval of 0 to 10
c
       data istart,icountr,icounts/0,0,0/  ! seed of random number generator
*--------------------------------------------------------------------72
c   prime random number generator
       xdummy=rand(0)

*--------------------------------------------------------------------72
c  welcome everybody!
c
       write(nlist,1200)
1200   format
     . (' this is montecarloD'/
     .  ' this program lets you perform montecarlo simulations:'/
     .  ' size distribution of populations of spheres: h(R)'/
     .  ' is defined in file dstb (101)'/
     .  ' the distribution is mapped between 0.00 and 1.00,'/
     .  ' the minimum and maximum values of h(R) are 0.00 and 1.00'/
     .  ' the maximum sectioning distance, d, is 1.00'/)
c
c   ask info
c
10001  write(nlist,1001)
1001   format
     . ('$no.of samples, no.of sections per sample > ')
       read(ncard,*,err=10001) nsample,nsect
c
10002  write(nlist,1004)
1004   format
     . ('$seeds for random distance and radius (2 integers) > ')
       read(ncard,*,err=10002) loopd, loopr
       
       rlow=0.
       rup=1.
       dmax=1.
 
*--------------------------------------------------------------------72
c   read distribution h(R) file 
c
10022  write(nlist,1022)
1022   format
     . ('$name of input file containing the distribution h(R) > ')
       read(ncard,5002,err=10022) distrib

       open(unit=iunit2,file=distrib,status='old',err=10022)
       do i=1,101    
       read(iunit2,*) dstb(i)
       enddo
       close(unit=iunit2) 
       
       if (nsample.eq.1) go to 45
        
*--------------------------------------------------------------------72
c   open stats file 

10023  write(nlist,1023)
1023   format
     . ('$name of file containing the statistics > ')
       read(ncard,5002,err=10023) bstats

       open(unit=iunit1,file=bstats,status='new',err=10023)
       write(iunit1,5002) bstats
       write(iunit1,5013) rlow,rup,dmax,nsample,nsect,loopr,loopd
5013   format
     . ('  rlow = ',f6.2,
     .  '  rup = ',f6.2,'  dmax = ',f6.2/
     .  '  nsample = ',i3,'  nsect = ',i3,'   loopr,loopd = ',2i3//)
       write(iunit1,5014)
5014   format
     . ('  av.no.r  av.av.r  av.sd.r  av.av.s  sd.av.s',
     .         '  av.sd.s  sd.sd.s  av.sk.s  sd.sk.s'/)

45      continue

*--------------------------------------------------------------------72
c   open list of r and R file 

10010  write (nlist,1020)
1020    format
     . ('$name of file containing list of R (spheres) > ')
       read(ncard,5002,err=10010) bradR
5002   format
     . (a)

       open(unit=iunit2,file=bradR,status='new',err=10010)
       write(iunit2,5002) '  #   R'
       
10016  write (nlist,1026)
1026    format
     . ('$name of file containing list of s (sections) > ')
       read(ncard,5002,err=10016) bradS
       
       open(unit=iunit3,file=bradS,status='new',err=10016)
       write(iunit3,5002) '  #   s'
       
       
c
*--------------------------------------------------------------------72
       write(nlist,1016)
1016   format
     . (' ')
c
*--------------------------------------------------------------------72
c  start
c
c   reset statistics
c
       ncount=0
       nr0=0
       ns0=0
       ns1=0
       ns3=0
       ns4=0
       nr1=0
       nr3=0
       nr4=0
       
       do 101 l=1,3
       sst1r0(l)=0.
       sst1s0(l)=0.
       sst1r1(l)=0.
       sst1s1(l)=0.
       sst1r3(l)=0.
       sst1s3(l)=0.
       sst1r4(l)=0.
       sst1s4(l)=0.
101    continue
c
*--------------------------------------------------------------------72
c   start experiment
c
1      continue
       ns=0
       nr=0
       
       do 100 l=1,3
       st1r(l)=0.
       st1s(l)=0.
100    continue
c
*--------------------------------------------------------------------72
c   start sample
c
c   select random distance
c
2      continue

       do ii=1,loopd
       d=rand(0)
       enddo
       
c
c   select random x (=R) and y (=h) and plot on curve h(R)
c
3      continue
       do ii=1,loopr
       x=rand(0)
       y=rand(0)
       enddo
       
c
c   if y(x) < h(R), i.e. y under curve, then OK if not, discard
c
       ix=100*x
       if(ix.lt.0.or.ix.gt.100) go to 3
       if(y.gt.dstb(ix+1)) go to 3
       
       r=x
       icountr=icountr+1

       call tsum(r,st1r,nr)
       
*--------------------------------------------------------------------72
* write ALL valid spheres x (= r = R) into R.file 

       write(iunit2,*) icountr,r

c
c   calculate intersection and write file
c
       if(d.gt.r) go to 2
       
       icounts=icounts+1
       ri=r-d
       s= sqrt(r*r - ri*ri)
       
       call tsum(s,st1s,ns)

*--------------------------------------------------------------------72
* write ALL possible sections into r.file 
*    = sections of spheres (R) that have been hit (d < R)

       write(iunit3,*) icounts,s
       
       if(ns.lt.nsect) go to 2
c
*--------------------------------------------------------------------72
c   terminate one sample
c
       ncount=ncount+1
       call term(st1r,nr,st2r)
       call term(st1s,ns,st2s)
c      
       call tsum(float(nr),sst1r0,nr0)
       call tsum(float(ns),sst1s0,ns0)
       call tsum(st2r(1),sst1r1,nr1)
       call tsum(st2r(3),sst1r3,nr3)
       call tsum(st2r(4),sst1r4,nr4)
       call tsum(st2s(1),sst1s1,ns1)
       call tsum(st2s(3),sst1s3,ns3)
       call tsum(st2s(4),sst1s4,ns4)
c
*--------------------------------------------------------------------72
c   terminate experiment
c
       if(ncount.lt.nsample) go to 1
       call term(sst1r0,nr0,sst2r0)
       call term(sst1s0,ns0,sst2s0)
       call term(sst1r1,nr1,sst2r1)
       call term(sst1r3,nr3,sst2r3)
       call term(sst1r4,nr4,sst2r4)
       call term(sst1s1,ns1,sst2s1)
       call term(sst1s3,ns3,sst2s3)
       call term(sst1s4,ns4,sst2s4)
c
c
*--------------------------------------------------------------------72
c   write in file
c
       if (nsample.eq.1) go to 46
       write(iunit1,5005) sst2r0(1),sst2r1(1),sst2r3(1),
     .    sst2s1(1),sst2s1(3),sst2s3(1),sst2s3(3),sst2s4(1),sst2s4(3) 
5005   format
     . (9f9.3)
5004   format
     . (2f12.5/)
5006   format
     . (6f12.5//)
     
       close(unit=iunit1)
46     continue       
       close(unit=iunit2)
       close(unit=iunit3)
       
       end
c
*--------------------------------------------------------------------72
c   subroutine chance
c
       subroutine chance (xquer, sigma, r)
c
c    calculates normally distributed pseudorandom numbers
c
c   r      real     output        pseudorandom number (0<r<1)
c   xquer  real     input         mean
c   sigma  real     input         standard deviation
c
       rsum = 0.
       do 70 i = 1,12
       rz=rand(0)
  70   rsum = rsum + rz
       r = (rsum - 6.) * sigma + xquer
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine tsum
c
       subroutine tsum(x, d, n)
       dimension d(3)
       ie=3
       if(abs(x).lt.0.00001) ie = 2
       do 100 i=1,ie
100    d(i)= d(i) +x**i
       n= n+1
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine term
c
       subroutine term(d, n, st)
       dimension d(3), st(4)
       if (n.le.1) go to 4000
       x1   =d(1)/n
       x2   =d(2)/n
       x3   =d(3)/n
       st(1)= x1
       st(2)= (d(2)-(d(1)*x1))/(n-1)
       st(3)= 0.00
       st(4)= 0.00
       if(st(2).le.0.) go to 70
       st(3)= sqrt(st(2))
       st(4)= (x3 -3.*x1*x2 +2.*x1*x1*x1)/(st(2)*st(3))
70     continue
4000   continue
       return
       end
*--------------------------------------------------------------------72
       subroutine randu(i2,r)
       
       r=rand(i2)
       return
       end
