*--------------------------------------------------------------------72
c
c   monte carlo simulations for grain size distributions
c
*--------------------------------------------------------------------72
c   correct sampling of r and s
c   update 20.7.95 for decent output file
c   23.7.95 random generator for any distribution
*   update 2010 - jan - 25
*   only one sample - no statistics
c
c   d       distance
c   r       radius of sphere
c   s       sectional radius
c   st1*    matrix of moments (in): st1r for radii of spheres
c                                   st1s for radii of sectional circles
c   st2*    matrix of moments (out)
c   sst***  "superstatistics": statistics of statistical parameters of 
c                              samples
c                              *****0: number
c                              *****1: mean
c                              *****2: variance
c                              *****3: standard deviation
c                              *****4: skewness
c

       program montecarloD
       
       dimension dstb(101)
       character*60 bfil,distrib,bstats,bradR,bradS
       data nlist,ncard,iunit1,iunit2,iunit3/6,5,1,2,3/
c
c   dmax scales input to interval of 0 to 10
c
       data istart,icountr,icounts/0,0,0/  ! seed of random number generator
*--------------------------------------------------------------------72
c   prime random number generator
       xdummy=rand(0)

*--------------------------------------------------------------------72
c  welcome everybody!
c
       write(nlist,1200)
1200   format
     . ('---------------------------------------------------------'/
     .  ' this is MONTECARLO                          24-aug-2010'/
     .  ' the program creates random samples of section ,s'/
     .  ' obtained by sectioning populations of spheres, R'//
     .  ' the size distribution of the spheres must be specified'/
     .  ' 1- standard uniform h(R)=1.00 (0.00 ≤ R ≤ 1.00)'/
     .  ' 2- Gaussian normal    or    3- General distribution h(R)'/
     .  ' for 3 need file with 101 values of h(R) (interval dR=0.01)'/
     .  ' (0.00 ≤ h(R) ≤ 1.00) and (0.00 ≤ R ≤ 1.00),'//
     .  ' the output file contains a list of N values of R and s'/
     .  '---------------------------------------------------------'/)
c
c   ask info
c
10001  write(nlist,1001)
1001   format
     . ('$no.of sections (size N of sample) > ')
       read(ncard,*,err=10001) nsect
c
10002  write(nlist,1004)
1004   format
     . ('$seeds for random distance and radius (2 integers) > ')
       read(ncard,*,err=10002) loopd, loopr
       
       rlow=0.
       rup=1.
       dmax=1.
 
*--------------------------------------------------------------------72
c   type of distribution 
c
10003  write(nlist,1003)
1003   format
     . ('$distribution ? 1-uniform 2-normal 3-other (1 integer) > ')
       read(ncard,*,err=10003) itype

       if (itype.ne.2) go to 100
*--------------------------------------------------------------------72
c   ask mean and standard dev.
10004   write(nlist,1005)
1005    format
     . ('$mean and std.dev. (2 numbers, both < 1.00) > ')
       read(ncard,*,err=10004) xm,sig
100    continue

       if (itype.ne.3) go to 200
*--------------------------------------------------------------------72
c   read distribution h(R) file 
c
10022  write(nlist,1022)
1022   format
     . ('$name of distribution file > ')
       read(ncard,5002,err=10022) distrib

       open(unit=iunit2,file=distrib,status='old',err=10022)
       do i=1,101    
       read(iunit2,*) dstb(i)
       enddo
       close(unit=iunit2) 
       
200    continue

*--------------------------------------------------------------------72
c   open list of r and R file 

10010  write (nlist,1020)
1020    format
     . ('$name of file for R (spheres) and s (sections > ')
       read(ncard,5002,err=10010) bradR
5002   format
     . (a)

       open(unit=iunit2,file=bradR,status='new',err=10010)
       write(iunit2,5002) '  #   R   s'
       
*--------------------------------------------------------------------72
       write(nlist,1016)
1016   format
     . (' ')
c
*--------------------------------------------------------------------72
c  start
       
c
*--------------------------------------------------------------------72
c   start experiment
c
1      continue
       ns=0
       nr=0
       
c
*--------------------------------------------------------------------72
c   start sample
c
c   select random distance
c
2      continue

       do ii=1,loopd
       d=rand(0)
       enddo
       
c--------- option 1 uniform
111    if (itype.ne.1) go to 222
       x=rand(0)
       r=x
       nr=nr+1
       s=0.0000

       go to 4

c--------- option 2 Gaussian normal
222    if (itype.ne.2) go to 333
       call chance(xm,sig,x)
       r=x
       nr=nr+1
       s=0.0000

       go to 4

c--------- option 3 General distirbution of R
333    continue

c   select random x (=R) and y (=h) and plot on curve h(R)

       do ii=1,loopr
       x=rand(0)
       y=rand(0)
       enddo
       
c   if y(x) < h(R), i.e. y under curve, then OK if not, discard

       ix=100*x
       if(ix.lt.0.or.ix.gt.100) go to 333
       if(y.gt.dstb(ix+1)) go to 333
       
       r=x
       nr=nr+1
       s=0.0000
c
c   calculate intersection and write file
c
 
 4     continue
       
       if(d.gt.r) go to 5
       
       ri=r-d
       s= sqrt(r*r - ri*ri)
       ns=ns+1
       

*--------------------------------------------------------------------72
* write ALL valid spheres x (= r = R) and 
* write ALL possible sections into file 
*    = sections of spheres (R) that have been hit (d < R)

5      continue

       write(iunit2,*) nr,r,s
       
       if(ns.lt.nsect) go to 2
c
*--------------------------------------------------------------------72
c   terminate experiment
c
*--------------------------------------------------------------------72
c   write in file
c
       close(unit=iunit1)
46     continue       
       close(unit=iunit2)
       
       end
c
*--------------------------------------------------------------------72
c   subroutine chance
c
       subroutine chance (xmean, sigma, r)
c
c    calculates normally distributed pseudorandom numbers
c
c   r      real     output        pseudorandom number (0<r<1)
c   xmean  real     input         mean
c   sigma  real     input         standard deviation
c
       rsum = 0.
       do 70 i = 1,12
       rz=rand(0)
  70   rsum = rsum + rz
       r = (rsum - 6.) * sigma + xmean
       return
       end
c
*--------------------------------------------------------------------72
       subroutine randu(i2,r)
       
       r=rand(i2)
       return
       end
