*--------------------------------------------------------------------72
c
c   calculation of h(r) from h(R)
c
*--------------------------------------------------------------------72
c
       dimension dstb(101)
       dimension sections(101), r(101,101)
       character*60 bfil,distrib
       data nlist,ncard,iunit1,iunit2/6,5,1,2/
       data smax/0.000/
c
c  welcome everybody!
c
       write(nlist,1200)
1200   format(' this is calcsecdis'/
     .   ' which calculates distribution of sections, h(r)'/ 
     .   ' from distributions of spheres, h(R).'/)           
c
c   ask info
c
10001  write(nlist,1001)
1001   format('$no. of bins in (max=101) and out (in  out) > ')
       read(ncard,*,err=10001) nbin, nbinout
10022  write(nlist,1022)
1022   format
     . ('$name of file with histogram of spheres h(R) (***.histR) > ')
       read(ncard,5002,err=10022) distrib
c
c   open files 
c
       open(unit=iunit2,file=distrib,status='old',err=10022)
       
       if (nbin.ne.nbinout) go to 61
       do i=1,nbin   
       read(iunit2,*) dstb(i)
       enddo
       close(unit=iunit2)
       go to 62
       
61     continue       
       do i=1,nbin   
       read(iunit2,*) dstb(i)
       enddo
       close(unit=iunit2)

       mbin= nbin/nbinout
       
       do i=1,nbinout   
       j=(i-1)*nbinout+1
       do jj=j,j+mbin-2
       dstb(j)=dstb(j)+dstb(jj)
       enddo
       enddo
       
       xbin=0
       do i=1,nbinout  
       j=(i-1)*nbinout+1
       dstb(i)=dstb(j)
       xbin=amax1(xbin,dstb(i))
       enddo
       
       nbin = nbinout
       
       do i=1,nbin
       dstb(i)=dstb(i)/xbin
       enddo

62     continue       

       
10010  write (nlist,1020)
1020    format('$filename for results (***.histS) > ')
       read(ncard,5002,err=10010) bfil
5002   format(a)
       open(unit=iunit1,file=bfil,status='new',err=10010)
       write(iunit1,5002) bfil
c
c
*--------------------------------------------------------------------72
c
1      continue
c
c   initialize
c
       do j=1,nbin
       sections(j)=0.0000
       do i=1,nbin
       r(i,j)=0.0000
       enddo
       enddo
       sumbin=0.
       sumsec=0.

c
c   distribution of sections for uniform distribution of r * distribution
c
       do j=1,nbin
       
       do i=1,j
       i1=i-1
       jj=j*j
       r(i,j)= (sqrt(float(jj-i1*i1))-sqrt(float(jj-i*i))) / nbin
       r(i,j)= dstb(j)*r(i,j)
       enddo

       enddo
c
       do i=1,nbin
       do j=1,nbin
       sections(i)=sections(i)+r(i,j)
       enddo
       enddo
       
       do i=1,nbin
       smax= amax1(smax,sections(i))
       sumsec=sumsec+sections(i)
       sumbin=sumbin+dstb(i)
       enddo
       
       
       print *,'sumbin (sum of R), sumsec (sum of S): ',sumbin,sumsec

       
c
c   write in file
c
5004   format(2f12.5)
c
c  write sections histogram
c
       write(iunit1,5005) 
5005   format('  r   h(R)   h(r)   hrel(r)')

       do 105 i=1,nbin
       ss=sections(i)/smax
       rr=sections(i)/sumsec*sumbin
       write(iunit1,*) i,dstb(i),rr,ss
105    continue      

       write(nlist,5006) 
5006   format('  file (r - h(R) - h(r)   hrel(r)) saved')

       close(unit=iunit1)
       end
c
