       program stripstar
c
c
       parameter (n_class=20)
       parameter (n_in=5)
       parameter (n_out=6)
       character*40 filnam, file_in, file_out
       dimension r(n_class,n_class)
       dimension sum(n_class)
       dimension recalc(n_class)
       dimension g(n_class)
       dimension gg(n_class)
       dimension f(n_class)
       dimension fneg(n_class)
       dimension fvol(n_class), fvox(n_class), vsize(n_class)
c
c   initialize
c
       do j=1,n_class
       sum(j)=0.0000
       f(j)=0.0000
       recalc(j)=0.0000
       do i=1,n_class
       r(i,j)=0.0000
       enddo
       enddo
c
c   input
c
       write(n_out,99)
99     format(
     . ' ----------------------------------------------------------'/
     . ' ***  stripstar  ***                         2012-06-01, rh'/
     . ' ----------------------------------------------------------'/
     . ' this program derives a possible distribution of spheres'/
     . ' from measured distributions of sectional areas.'/
     . ' it requires input in the form of binned data: '/
     . ' histogram h(r): r = radius;  h = number frequency;'/
     . ' -------------------------------------------------------')

       write(n_out,103)
103    format(/'indicate if input is manual (0) or by file (1) >')    
       read(n_in,*) nchoice

       if(nchoice.eq.0) go to 3

2      write(n_out,100) n_class
100    format(/'file must contain list of h(r) '/
     .'line 1: no. of bins (max. = ',i2,'), width of bin'/
     .'line 2 ff.: h(r)')

       write(n_out,104)
104    format(/'name of input file > ')
       read(n_in,210) file_in
210    format(a)

       open(unit=1,file=file_in, status='old')
       read(1,*) n,clinc
       do i=1,n
       read(1,*,err=2) g(i)
       enddo
220    format(i10)   
       close(unit=1)

       go to 4

3      continue

1      write(n_out,101) n_class
101    format(/'indicate number of classes of histogram'/
     .'h(r) (up to ',i2,') >')
       read(n_in,220) n
       if(n.gt.n_class) go to 1

       write(n_out,113)
113    format(/'indicate class width of h(r) (mm/inch/units/...) > ')
       read(n_in,*) clinc
       
5      write(n_out,105) n_class
105    format(/'type ',i2,' input frequencies (# or %)',
     .' (from smallest to largest)')
       do i=1,n
       write(n_out,102) i
       read(n_in,*,err=5) g(i)
       enddo
102    format('bin no.',i2,': ')

4      continue
c
c      test if g(n) is zero - keep nn
c
       nn=n
       do j=1,n
       k=n+1-j
       if (g(k).gt.0.0000) go to 7
       enddo
7      continue
       n=k
       write(n_out,230) n
230    format(/'largest no-zero bin is h(',i2,')')
       
c
c   distribution of sections for uniform distribution of r
c
       do j=1,n
       do i=1,j
       i1=i-1
       jj=j*j
       r(i,j)= (sqrt(float(jj-i1*i1))-sqrt(float(jj-i*i))) / n
       enddo
       enddo
c
       do i=1,n
       do j=1,n
       sum(i)=sum(i)+r(i,j)
       enddo
       enddo
c
       write(n_out,204)
c
       if(n.le.10) then
       write(n_out,206)
206    format(' matrix r(i,j):')   
       write(n_out,208)
208    format(' i (row)    = size of section,'/
     .        ' j (column) = produced by size of sphere'/)
       write(n_out,2001) (j,j=1,n)
       do i=1,n
       write(n_out,201) i,(r(i,j),j=1,n)
       enddo
       write(n_out,207)
207    format(//' h(r) for uniform h(r): h(r)i = ',
     . '(horizontal) sum (r)i,j=1,n')
       do i=1,n
       write(n_out,205) i,sum(i)
       enddo
c      
       else
       write(n_out,206)
       write(n_out,208)
       write(n_out,2001) (j,j=1,10)
       do i=1,n
       write(n_out,201) i,(r(i,j),j=1,10)
       enddo
       write(n_out,204)
       write(n_out,2001) (j,j=11,n)
       do i=1,n
       write(n_out,201) i,(r(i,j),j=11,n)
       enddo
       write(n_out,207)
       do i=1,n
       write(n_out,205) i,sum(i)
       enddo
       endif
201    format(1x,i3,1x,10f8.5)
2001   format(5x,10i8)
c
c   analysis of historgram of sections (input)
c
       do i=1,n
       gg(i)=g(i)*r(n,n)/g(n)
       enddo
c
5000   continue
       do k=1,n
       m=n-k+1
       factor=gg(m)/r(m,m)
       if(factor.gt.0.0000) f(m)= factor
       fneg(m)= factor
        do i=1,n
        gg(i)=gg(i)-factor*r(i,m)
c       if(gg(i).lt.0.0000) gg(i)=0.00
        enddo
       enddo
c
c   recalculate sections from positive radii
c
       gsum=0.0
       do i=1,n
       gg(i)=g(i)/g(n)
       gsum=gsum+g(i)
       enddo
c
       do i=1,n
       do j=1,n
       recalc(i)=recalc(i)+r(i,j)*f(j)
       enddo
       enddo
       do i=1,n
       recalc(i)=recalc(i)/recalc(n)
       enddo
c
c   create result file
c

       write(n_out,108) 
108    format(/' name of output file')
       read(n_in,210) file_out
       open(unit=2,file=file_out,status='new')   

c
c   write output
c
       write(n_out,204)
204    format(/)
       write(n_out,203) n
203    format(t13,'calculated distributions:',t46,'comparison:'/
     . t13,'spheres',t25,'sph.& antispheres',t46,
     .     'rel.input sections',t67,'recalc.sections'/
     . '  class',t13,'h(R)',t25,'h*(R)',t46,
     . '(h(',i2,') = 1.00):',t67,'from h(R):'/)
       do i=1,n
       write(n_out,205) i,f(i), fneg(i), gg(i), recalc(i)
       enddo
205    format(i5,2f15.5,t45,2f16.5)
c
c      weight percent
c
       write(n_out,204)
       write(n_out,217)
       write(2,217)
217    format(t25,'r=radius of sections,  R=radius of spheres'/
     . t25,'spheres only', t50, 'spheres & antispheres'/
     . t9,'r',t13,'h(r)(%)',t25,
     .    'h(R)(%)',t37,'v(R)(%)',t50,'h*(R)(%)',t64,'v*(R)(%)'/)
c

       sumf=0.0000
       sumv=0.0000
       sumn=0.0000
       sumx=0.0000
       
       do i=1,n
       sumf=sumf+f(i)
       sumn=sumn+abs(fneg(i))
       x=i*clinc
       vsize(i)=x*x*x*4.1887902    ! = 4*3.14159/3 * r*r*r
       fvol(i)=f(i)*vsize(i)
       fvox(i)=fneg(i)*vsize(i)
       sumv=sumv+fvol(i)
       sumx=sumx+abs(fvox(i))
       enddo
       
       do i=1,n
       f(i)=100.0*f(i)/sumf
       fneg(i)=100.0*fneg(i)/sumn
       fvol(i)=100.0*fvol(i)/sumv
       fvox(i)=100.0*fvox(i)/sumx
       g(i)=100.0*g(i)/gsum
       enddo
c
       do i=1,n
       c=i*clinc
       write(n_out,215) c, g(i), f(i), fvol(i), fneg(i), fvox(i)
       enddo
215    format(f9.3,f10.2,2f12.2,t48,f10.2,t62,f10.2)

       if(n.eq.nn) go to 250

       do i=n+1,nn
       g(i)=0.0
       f(i)=0.0
       fvol(i)=0.0
       fneg(i)=0.0
       fvox(i)=0.0
       enddo

250    do i=1,nn
       c=i*clinc
       write(2,215) c, g(i), f(i), fvol(i), fneg(i), fvox(i)
       enddo
c
       close(unit=2)
       
       print *,' '
       end
