*--------------------------------------------------------------------72
c   program surfor        surf(ace) or(ientation)
*--------------------------------------------------------------------72
c   surface orientation by orientation of unit line segments
c
c      bti                 (132 byte)
c      ntot                (1 integer)
c      x,y                 (2 real)
c                           end of string: e.g. 999999.,999999.
c
c   bti   header
c   ntot  number of x-y coordinate points stored in file
c   x,y   x-y coordinates of digitized contour lines
c
c   output files:
c   -printout     (e.g., ***.s10 : printout with 10 deg. interval)
c   -A(alpha)     (e.g., ***.i10 : 10 deg. interval between points)
c   -rose diagram (e.g., ***.r10 : 10 deg. sectors)
c                 (of total length of surface, = surface ODF)
c
c   update 20.6.2007, 2.12.2009
*** update 8.11.2010
*** update 23.11.2010  print results
c
       dimension p1(370), ptot(370), ros(370), xcs(370), ycs(370)
       dimension sum1(3,370), stat1(4,370)

c   p1      projection of single line segment
c   sum1    sum of projections
       
       dimension nstar1(370), nstar2(370), pstdev(370)
       character bfil*40, bout*40, bspl*40, bros*40, btemp*40
       character bchs*40
c
c   bfil     name of input file
c   bout     name of output file
c   bspl     name of spline input file (for a(alpha) diagram)
c   bros     name of rose input file (for rose diagram of odf)
c
       character bti*132,histo*100
c
c   bti     header of input/output file
c   histo   array to create printed histogram
c
       character*1 ans,hyphen,blank,stars,colon,plus
       character*1 qstd
       data hyphen,blank,stars,colon,plus,qstd/'-',' ','*',':','+','y'/
       data pi,pir,fac/3.14159,57.29578,0.01745/
       data idim,mdeg,lbyte,incmin/370,360,132,1/
       data iunit,ncard,nlist,lenhis,ipro/1,5,6,60,1/
       data ntest0,iunit2/20,2/
c
c   dimension of arrays such that minimum angular interval = 1 degree.
c   -> 360 intervals per circle (including safety)
c
*--------------------------------------------------------------------72
c    initialize
c
       lup=180
       low=-lup
       nfin=0
       iprint=0
       do 99 i=1,idim
       ros(i)=0.
       do 99 j=1,3
       sum1(j,i)=0.
99     continue
       nseg=0
       ndx1=0
       ndx2=0
c
*--------------------------------------------------------------------72
c   ask information
c
1000   continue
       write(nlist,1001)
1001   format(
     . ' -----------------------------------------------------------'/
     . ' ***  surfor  ***                             2010-12-21, rh'/
     . ' analysis of bulk surface fabric'/
     . ' (open or closed outlines)'/
     . ' -----------------------------------------------------------'/
     . ' input file:'/
     . '    line 1:            bti          title (must have)'/
     . '    line 2:            n            total number of points'/
     . '    line 3 ff.:        x,y          floating x-y coordinates'/
     . '    |                  ...          ...etc.'/
     . '    | (optional)       Xend,Yend    end coordinates'/
     . ' -----------------------------------------------------------'/
     . ' number of points and particles is unlimited'/
     . ' -----------------------------------------------------------')

10010  write (nlist,1020)
1020    format(' name of input file > ')
       read(ncard,5005,err=10010) bfil

       write(nlist,1032)
1032   format
     . (' end coordinates in input (0.000, 9999, ... one number) > ')
       read(ncard,*) xend
       yend=xend
c
c   ask about graphic output
c
       write(nlist,1006)
1006   format(' do you want printout (0), file (1), both (2) ? > ')
       read(ncard,*) iprint
c
3      continue
c
4      continue
c
c   angular resolution
c
       write(nlist,1011) incmin
1011   format 
     . (' increment of rotation angle (minimum =',i2,' deg.) > ')
       read (ncard,*) incr
       nincr= mdeg/incr/2
       incro=incr
c
2      continue
c
       if(iprint.eq.0) go to 5
c
*--------------------------------------------------------------------72
c   other file names
c
       bout=bfil
       bros=bfil
       bspl=bfil
       bchs=bfil
       ml=mlen(bfil)
       ml2=ml-3
       write(bout(ml2:ml),'(a,a,i2.2)') '.','s',incr
       write(bspl(ml2:ml),'(a,a,i2.2)') '.','i',incr
       write(bros(ml2:ml),'(a,a,i2.2)') '.','r',incro
       write(bchs(ml2:ml),'(a,a,i2.2)') '.','c',incro
c
c   verify
c
       write(nlist,1013) bout(1:ml)
1013   format(' name of output file ? [',a,'] (return=default) > ')
       read(ncard,5005) btemp
       if(mlen(btemp).ne.0) bout=btemp
       write(nlist,1014) bspl(1:ml)
1014   format(' name of file with A(alfa) curve ? [',a,'] > ' )
       read(ncard,5005) btemp
       if(mlen(btemp).ne.0) bspl=btemp
5      continue
       write(nlist,1015) bros(1:ml)
1015   format (' name of file with surface ODF ? [',a,'] > ')
       read (ncard,5005) btemp
       if(mlen(btemp).ne.0) bros=btemp
       write(nlist,1016) bchs(1:ml)
1016   format (' name of file with charactersitic shape? [',a,'] > ')
       read (ncard,5005) btemp
       if(mlen(btemp).ne.0) bchs=btemp
c
*--------------------------------------------------------------------72
c   open file 
c

       open(unit=iunit, file=bfil,status='old',
     .      form='formatted', access='sequential')
c
c   start calculations
c
       read (iunit,5005) bti(1:60)
       write (nlist,5007) bfil(1:ml)
       write (nlist,5008) bti(1:60)
5007   format('opening file: ',a)
5008   format('header:  ',a)
c
c   formats
c
5000   format(i5)
5005   format(a)
5006   format(i5,f12.5)
c
*--------------------------------------------------------------------72
c   start calculation

c   prepare scaling
c
       dfsum=0.
       nf=0
       ntest=ntest0
       read(iunit,*) ntot
       if(ntest.gt.ntot) ntest=ntot
       read(iunit,*) fx2,fy2
       do 6 i=1,ntest
       fx1=fx2
       fy1=fy2
       read(iunit,*) fx2,fy2
       if(fx2.eq.xend) go to 7
       nf=nf+1
       dx= fx2-fx1
       dy= fy2-fy1
       d = sqrt(dx*dx+dy*dy)
       dfsum=dfsum+d
6      continue
7      continue
       dtyp=dfsum/nf
       factor=1./dtyp
       facinv=dtyp
       rewind(iunit)
       read (iunit,*) bti(1:lbyte)
       read (iunit,*) ntot
c
c   repeated input until xend,yend  (=end of coordinate string)
c
       read(iunit,*) fx2,fy2

*------------ start

       do 8 ijk=1,ntot-1
       
       fx1= fx2
       fy1= fy2
       read(iunit,*) fx2,fy2
       if (fx1.ne.xend.and.fx2.ne.xend) go to 9
       go to 8
9      continue
       nfin=nfin+1
       dx= (fx2-fx1)*factor
       dy= (fy2-fy1)*factor
       if(ipro.eq.0) go to 10    ! ipro is set to 1
c
c   projection of lines
c
       if(dx.gt.0.) ndx1=ndx1+1
       if(dx.le.0.) ndx2=ndx2+1
       
       call proj(dx,dy,incr,p1)
       
       call dsum(p1,nincr,sum1,nseg)
c
c   rose diagrams
c
10     continue
       call rose(dx,dy,low,lup,incro,ros)

8      continue

*------------ end

       close(unit=iunit)
c
c   end loop, finish statistics, find max min
c
       if(ipro.eq.0) go to 12        ! ipro is set to 1
       
       surfprojmin = 999999.
       surfprojmax = -999999.
       
       do i=1,nincr
       surfprojmin = amin1(surfprojmin,sum1(1,i))
       surfprojmax = amax1(surfprojmax,sum1(1,i))       
       enddo
       
       do i=1,nincr
       if(sum1(1,i).ne.surfprojmax) go to 1199
       imax=i
       alfamaxA=float(imax*incr)
1199   if(sum1(1,i).ne.surfprojmin) go to 1200
       imin=i
       alfaminA=float(imin*incr)
1200   continue
       enddo

       Amax= sum1(1,imax)
       Amin= sum1(1,imin)
       aniso= Amin/Amax
       if (alfamaxA.gt.alfaminA) diffalfa = alfamaxA-alfaminA
       if (alfamaxA.lt.alfaminA) diffalfa = alfamaxA+180.-alfaminA
       
       write(nlist,3001) Amin,Amax
3001   format(/'A(alfa)min =',t18,f10.3,t40,
     . 'A(alfa)max =',t56,f10.3)
       write(nlist,3003) alfaminA, alfamaxA
3003   format('Alfamin =',t16,f10.1,t40,'Alfamax =',t54,f10.1)
       write(nlist,3002) aniso 
3002   format('Bulk b/a =',t26,f10.5)
       write(nlist,3004) diffalfa 
3004   format('Angular difference =',t22,f10.1)
       write(nlist,3005)
3005   format('(diff < 90 deg = dextral monoclinic)'/)
       alfap2= 90.-alfaminA
       alfap1= 180.-alfamaxA
       write(nlist,3006) alfap1, alfap2
3006   format('Preferred orientation (of LA1) alfap1 = ', f6.0/
     .        'Preferred orientation (of LA2) alfap2 = ', f6.0)       
       write(nlist,706)
       
       call term(nincr,sum1,nseg,stat1)
c
c   results are scaled and stored in stat1
c
       do 15 ij=1,nincr
       stat1(2,ij)= stat1(2,ij)*facinv
       do 15 ji=1,4
       stat1(ji,ij)= stat1(ji,ij)*facinv
15     continue
       do 16 iq=1,nincr
       ptot(iq)= stat1(1,iq)*float(nseg)
       pstdev(iq)= stat1(3,iq)* float(nseg)
16     continue
c
c   prepare printed histogram
c
       call sstar(ptot,pstdev,nincr,lenhis,nstar1,nstar2)
       stmax=-99999.
       do 19 j=1,nincr
       stmax= amax1(stmax,ptot(j))
19     continue
       indhis= ifix(stmax+ .5)
       if(ans.eq.'r'.or.ans.eq.'r') go to 20
20     continue
c
*--------------------------------------------------------------------72
c   create file ***.r..

12     continue

       mincro=mdeg/incro
       mini= mincro/2
       
       do 122 i=1,mini
       ros(i)=0.5*(ros(i)+ros(i+mini))
       ros(i+mini)=ros(i)
122    continue      

*--------------------------------------------------------------------72
c   create file for charactersitic shape ***.c..
c

       open(unit=iunit,file=bros,status='new',
     .       form='formatted',access='sequential')
     
       open(unit=iunit2,file=bchs,status='new',
     .       form='formatted',access='sequential')
     
       write(iunit,720) 
720    format(' angle   length_of_surface  rel.length_surface')       

       write(iunit2,820) 
820    format(' x   y_characteristic_shape')       
     
     
c***surface ODF

       surfmax=0.0
       
       do  i=1,mincro
       surfmax=amax1(surfmax,ros(i))
       enddo
       
       xincrem=-180.
       rr=facinv*ros(mincro)
       rrrel=ros(mincro)/surfmax
       write(iunit,*) xincrem,rr,rrrel
       
c***characteristic shape
       
       xcs(1)=0.00
       ycs(1)=0.00
*       write(iunit2,*) xcs,ycs
       
c***surface ODF
       
       do 22 i=1,mincro
       iii=i+1
       xincrem=xincrem+0.5*incro
       rr=0
       write(iunit,*) xincrem,rr,rr

       xincrem= low + i*incro
       rr=facinv*ros(i)
       rrrel=ros(i)/surfmax
       write(iunit,*) xincrem,rr,rrrel
       
c***characteristic shape

       xcs(iii)=xcs(i)+cos(fac*xincrem)*rr
       ycs(iii)=ycs(i)+sin(fac*xincrem)*rr
*       write(iunit2,*) xcs,ycs

22     continue

       close(unit=iunit)
       
* scale characteristic shape between -1 and 1       
       
       xxmax=-999999
       yymax=-999999
       xxmin= 999999
       yymin= 999999
       
       do i=1,mincro
       xxmax=amax1(xxmax,xcs(i))
       yymax=amax1(yymax,ycs(i))
       xxmin=amin1(xxmin,xcs(i))
       yymin=amin1(yymin,ycs(i))
       enddo
       
       xxspan= abs(xxmax-xxmin)
       xxzero= 0.5*(xxmax+xxmin)
       yyspan= abs(yymax-yymin)
       yyzero= 0.5*(yymax+yymin)
       
       if(xxspan.ge.yyspan) chscale= 1.8/xxspan
       if(xxspan.le.yyspan) chscale= 1.8/yyspan
       
       do i=1,mincro
       xcs(i)=(xcs(i)-xxzero)*chscale
       ycs(i)=(ycs(i)-yyzero)*chscale
       write(iunit2,*) xcs(i),ycs(i)
       enddo
       
       write(iunit2,*) xcs(1),ycs(1)
       close(unit=iunit2)


*--------------------------------------------------------------------72
c   print results and/or create file
c
c   titles
c
       if(ipro.eq.0) go to 9000
       if(iprint.eq.1) go to 8000
       write(nlist,701) bfil
701    format(/'surfor analysis of ', a)
702    format(/' length of line segments')
       write(nlist,704) nseg,ndx1,ndx2
704    format(/' number of projected line segments: ', i5/
     .   t37,i5,' where delta x > 0'/t37,i5,' where delta x < 0'
     .  //' total length of projected line segments, a(alpha):')
706    format(/)
       write(nlist,707) 
707    format(/' angle', t14,'total', t28, 'mean', t37,
     .   ' variance', t51, 'st.dev.',t64,'skewness'/)
       do 31 i=1,nincr
       jincr=i*incr
       write(nlist,708) jincr, ptot(i), (stat1(ii,i),ii=1,4)
31     continue
708    format(i6,5f13.5)
c
c   histogram
c
       write(nlist,709) indhis, ((hyphen),i=1,lenhis)
709    format(//' histogram: total length of projection A(alpha)',
     . ' versus angle of rotation'//
     .   t55,i5,' length'/t13,100a1)
       do 34 i=1,nincr
       jstar=nstar1(i)
       kstar=nstar2(i)
       jincr=i*incr
       if(jincr.gt.180) jincr= jincr-180
       if(kstar.gt.lenhis) kstar= lenhis
       do 35 ko=1,jstar
       histo(ko:ko)=stars
       if(kstar.gt.jstar.and.(qstd.eq.'y'.or.qstd.eq.'y'))
     .                           histo(ko:ko)= plus
35     continue
       if(qstd.ne.'y'.and.qstd.ne.'y') go to 36
       low=1
       if(kstar.gt.jstar) low = jstar+1
       do 37 ko=low,kstar
       histo(ko:ko)=colon
37     continue
36     continue
       write(nlist,710) jincr,(histo(ko:ko),ko=1,jstar)
       if(jincr.eq.180) write(nlist,706)
34     continue
710    format(i10,2x,100a1)
       if(iprint.eq.0) go to 9000
c
*--------------------------------------------------------------------72
c   create output file ***.s..
c
8000   continue
       if(iprint.eq.0) go to 9000
       open(unit=iunit,file=bout,status='new',
     .       form='formatted',access='sequential')
       write(iunit,701) bfil

       write(iunit,3001) Amin,Amax
       write(iunit,3003) alfaminA, alfamaxA
       write(iunit,3002) aniso 
       write(iunit,3004) diffalfa 
       write(iunit,3005)
       write(iunit,3006) alfap1, alfap2
       
       write(iunit,702)
       write(iunit,704) nseg,ndx1,ndx2
       write(iunit,706)
       write(iunit,707) 
       do 39 i=1,nincr
       jincr=i*incr
       write(iunit,708) jincr, ptot(i), (stat1(ii,i),ii=1,4)
39     continue
       write(iunit,709) indhis, ((hyphen),i=1,lenhis)
       do 42 i=1,nincr
       jstar=nstar1(i)
       kstar=nstar2(i)
       jincr=i*incr
       if(jincr.gt.180) jincr= jincr-180
       if(kstar.gt.lenhis) kstar= lenhis
       do 43 ko=1,jstar
       histo(ko:ko)=stars
       if(kstar.gt.jstar) histo(ko:ko)= plus
43     continue
       low=1
       if(kstar.gt.jstar) low = jstar+1
       do 45 ko=low,kstar
       histo(ko:ko)=colon
45     continue
44     continue
       write(iunit,710) jincr,(histo(ko:ko),ko=1,jstar)
       if(jincr.eq.180) write(iunit,706)
42     continue
       close(unit=iunit)
       
*--------------------------------------------------------------------72
c   create file for spline input ***.i..
c
       open(unit=iunit,file=bspl,status='new',
     .       form='formatted',access='sequential')
     
       write(iunit,721)
721    format(' angle   relative_length_of_projection')   

       ptotmax=0
       do 50 i=1,nincr
       jincr=i*incr
       ptotmax=amax1(ptotmax,ptot(i))
50     continue

       write(iunit,5006) 0,ptot(nincr)/ptotmax

       do 51 i=1,nincr
       jincr=i*incr
       ptot(i)=ptot(i)/ptotmax
       write(iunit,5006) jincr,ptot(i)
51     continue
       close(unit=iunit)
9000   continue
       end

c***********************************************************************
c
c   subroutine proj
c
       subroutine proj(x,y,i,e)
       dimension e(1)
       fac= 0.01745*float(i)
       m=180/i
       a=tany(x,y)
       xl= sqrt(x*x+y*y)
       do 100 j=1,m
       b= a+ float(j)*fac
       e(j)= pr(xl,b)
100    continue
       return
       end
c
c***********************************************************************
c
c   subroutine rose, updated sep-2-1985: centered intervals
c
       subroutine rose(x,y,iu,io,i,r)
       dimension r(1)
       fac= 57.295780
       unt= float(iu) + .5*float(i)
       ob = float(io) - .5*float(i)
       m= (io-iu)/i
       xl= sqrt(x*x+y*y)
       ang= tany(x,y)*fac+ .001
       is= m
       if(ang.lt.unt.or.ang.ge.ob) go to 80
       do 70 jj=1,m-1
       anv= unt + float(jj*i)
       is= jj
       if(ang.lt.anv) go to 80
70     continue
80     continue
       r(is)=r(is)+xl
       return
       end
c
c***********************************************************************
c
c   function pr
c
       function pr(x,a)
       c=abs(cos(a))
       pr= c*x
       return
       end
c
c***********************************************************************
c
c   function tany
c
       function tany(x,y)
       pi=3.14159
       fi= pi/2.
       if(x.ne.0.) fi = atan(y/x)
       if(x.lt.0..and.y.ge.0.) fi=fi+pi
       if(x.lt.0..and.y.lt.0.) fi=fi-pi
       tany=fi
       return
       end
c
c***********************************************************************
c
c   subroutine sstar
c
        subroutine sstar (rphi, sphi, mfang, laeng, nstarr, nstars)
        dimension rphi(mfang), nstarr(mfang)
       dimension sphi(mfang), nstars(mfang)
        rmax= 0.
       do 99 i=1,mfang
       nstarr(i)=0
       nstars(i)=0
99     continue
        do 100 j=1,mfang
  100   rmax= amax1 (rphi(j), rmax)
       if(rmax.eq.0) go to 102
        do 101 j=1,mfang
        nstarr(j)= ifix (float(laeng)* rphi(j)/ rmax)
       nstars(j)= ifix (float(laeng)* sphi(j)/ rmax)
101    continue
102    return
        end
c
c***********************************************************************
c
c   subroutine dsum
c
       subroutine dsum(x,m,t,n)
       dimension x(m), t(3,m)
       do 100 i2= 1,m
       ie=3
       if(abs(x(i2)).lt.0.00001) ie= 2
       do 100 i1= 1,ie
       t(i1,i2)= t(i1,i2) +  x(i2)**i1
100    continue
       n= n+1
       return
       end
c
c***********************************************************************
c
c   subroutine term
c
       subroutine term (m, t, n, tt)
       dimension t(3,m), tt(4,m)
       do 99 i=1,m
       tt(2,i)= 0.0000
       tt(3,i)= 0.0000
       tt(4,i)= 0.0000
99     continue
       do 100 i= 1,m
       tt(1,i)= t(1,i)/n
       if (n.le.1) go to 100
       tt(2,i)= (t(2,i)-t(1,i)*t(1,i)/n)/(n-1)
       fract=tt(2,i)/tt(1,i)
       if(fract.lt.1.e-06) go to 50
       tt(3,i)= sqrt(tt(2,i))
50     continue
       if(tt(3,i).eq.0.) go to 100
       do 101 ii=1,3
101    t(ii,i)= t(ii,i)/n
       ttt= tt(3,i)*tt(3,i)*tt(3,i)
       tt(4,i)= (t(3,i)-3.*t(1,i)*t(2,i)+2.*t(1,i)*t(1,i)*t(1,i))/ttt
100    continue
       return
       end
c***********************************************************************
c
c   function mlen
c
       integer function mlen(s)
c
c      determine actual length of string s
c
       character *(*) s
       l=len(s)
       do 10 k=l,1,-1
       lg=k
       ivalue=ichar(s(k:k))
       if(.not.(ivalue.eq.32.or.ivalue.eq.0)) goto 99
   10  continue
       lg=0
   99  mlen=lg
       return
       end
