*---------------------------------------------------------------------72
c       program scasmo        sca(le) and smo(oth) 
*---------------------------------------------------------------------72
c
c   produces scaled and smoothed x-y coordinates from digitized input
c
c   input:  file with strings of integer coordinates ix,iy 
c
c   output: formatted file:  bti(132a1)         title
c                            n  (i5)            number of points in file
c                            x,y(2f12.5)        x-y coordinates
c                            xend,yend(2f12.5)  endpoints of strings
c   basel, 23.4.2010 rh
c   basel, 25.10.2010 rh: 
c   set iover to 3 => particles with 3 pts can be closed AND smoothed
c   in case of smooth set 1st and last new X/Y coordinate to same mean value
*---------------------------------------------------------------------72
c   removes duplicate points
*---------------------------------------------------------------------72
c   does not ask for spacing if no smoothing
*---------------------------------------------------------------------72

       dimension x(4021),y(4021)
c
c   x       x-coordinates after scaling, i.e., true size in mm
c   y       y-coordinates after scaling, i.e., true size in mm
c
       dimension xnew(4521),ynew(4521),digerr(4521)
c
c   xnew    x-coordinates after scaling and smoothing
c   ynew    y-coordinates after scaling and smoothing
c   digerr  digitizing error, same scale as x-y coordinates
c
       character btemp*100,bfil1*100,bfil2*100,b_newcoord*100,bti*132
c
c   b       array to accept digitzed input
c   bfil1   input file name
c   bfil2   output file name
c   btemp   temporary file name
c   bti     title of output file, optional
c
       data lbyte,nterm/132,5/
       data iunit1,iunit2,ncard,nlist/1,2,5,6/

c
c   lbyte   length of title array
c   nterm   unit number of terminal
c
       data iover,maxpt,minpt,mdim/3,4000,3,4021/
c
c   iover   overlap of string endpoints for smoothing
*           iover should be  minpt, 25.10.2010
c   maxpt   maximum number of points per individual string
c   minpt   minimum number of points per individual string
c   mdim    dimension of x,y,xnew,ynew,digerr in main program
c           = maxpt+iover+iover+1
c           check further arrays in subroutine smout !
c
       bti= ' '
1      continue
c
c   input file
c
       write(nlist,1001) maxpt,minpt
1001   format
     .(' -----------------------------------------------------------'/
     . ' ***  scasmo  (full) ***                      2012-02-15, rh'/
     . ' -----------------------------------------------------------'/
     . ' converts digitized files to formatted input files'/
     . ' plus optional: scaling, smoothing, closing of outlines'/
     . ' plus optional: reduction of number of coordinate points'/
     . ' maximum number of points per particle = ',i5/
     . ' particles with less than ',i1,' points are discarded'/
     . ' -----------------------------------------------------------'/
     . ' input file:'/
     . '    for each particle: x,y          x-y coordinates'/
     . '    |                  ...          ...etc.'/
     . '    |                  X,Y          end coordinate (X=Y)'/
     . ' output file:'/
     . '    line 1:            bti          title'/
     . '    line 2:            n            total number of points'/
     . '    for each particle: x,y          floating x-y coordinates'/
     . '    |                  ...          ...etc.'/
     . '    |                  Xend,Yend    end coordinates'/
     . ' ----------------------------------------------------------'/
     . 'name of input file:')

        read(ncard,5002) bfil1
c
*---------------------------------------------------------------------72
c   open input file 
c
       open(unit=iunit1, file=bfil1,status='old',
     .      form='formatted', access='sequential')

*---------------------------------------------------------------------72
c   ask specifications
c
       write(nlist,1002)
1002   format('magnification (mm/inch/etc. per pixel):')
       read(ncard,*) scale

       write(nlist,1032)
1032   format
     . ('end coordinates of input file (one number): ')
       read(ncard,*) ixend
       iyend=ixend

       write(nlist,1042)
1042   format
     . ('end coordinate of output file (one number): ')
       read(ncard,*) xend
       yend=xend

       write(nlist,1026)
1026   format('want to reduce number of digitized points ?'/
     .  ' 1=yes, 0=no' )
       read(*,*,err=1) ireduce
       distmin=0.0

       if(ireduce.ne.1) go to 3
 
       write(nlist,1025)
1025   format('resolution (resampling between points):'/
     . '(1)fine (2)medium (3)coarse (4)manual' )
       read(*,*,err=1) mindist
       if(mindist.ne.4) go to 3

       write(nlist,1029)
1029   format('indicate min.dist (same units as outlines): ')
       read(*,*) distmin
       
3      continue
       print*,'distmin = ', distmin
       
       write(nlist,1006)
1006   format('want completed outlines ? (1=yes, 0=no):')
       read(ncard,*) icmpl
       if(icmpl.eq.0) iover=0

       write(nlist,1012)
1012   format('want smoothing ? 1=yes,0=no :')
       read(ncard,*) ispli
       if(ispli.ne.1) go to 4

       write(nlist,1004)
1004   format('smoothing error (in pixel units): ')
       read(ncard,*) digi
       digi= digi*scale
       do 2 i=1,mdim
       digerr(i)=digi
2      continue

4      continue

       write(nlist,1005)
1005   format
     . ('want inverted axes? 0=no; 1=x-axis; 2=y-axis; 3=both :')
       read(ncard,*) invers

       ireg=0
       if(ispli.ne.1) go to 14
       write(nlist,1015)
1015   format('want spacing... 1=regular, 0=as digitized :')
       read(ncard,*) ireg
14     continue

*---------------------------------------------------------------------72
c   create file names
c
       ml=mlen(bfil1)
       bfil2=bfil1
       b_newcoord=bfil1
       ml2=ml+4
       if(ml2.gt.100) print *, 'file name will be truncated'
       if(ml2.gt.100) ml2=100
       ml1=ml2-3
       bfil2(ml1:ml2)='.scm'
c
c   verify
c
       write(nlist,1009) bfil2(1:ml2)
1009   format('name of output file ? [',a,'] (return=default):')
       read(ncard,5002) btemp
       if(mlen(btemp).ne.0) bfil2=btemp


10005  continue
       write(nlist,1011)
1011   format('type header (maximum length = 132 characters): ')
       read(ncard,5002,err=10005) bti

c
*---------------------------------------------------------------------72
c   open scratch file 
c
       open(unit=iunit2, status='scratch',
     .      form='unformatted', access='sequential')
       
*---------------------------------------------------------------------72
c
       nnew=0
       np=0
       ixlast=0
       iylast=0

*---------------------------------------------------------------------72

1999   np=0

2000   read (iunit1,*,end=2009,err=2999) ix,iy

       if((ix.eq.ixlast).and.(iy.eq.iylast))  go to 2000
       ixlast=ix
       iylast=iy
       
       go to 2010
*---------------------------------------------------------------------72
*   if end of input

2009   continue
       if (np.ne.0) go to 2001
       go to 2999
       
*---------------------------------------------------------------------72
2010   continue
       
       if(ix.eq.ixend.and.iy.eq.iyend) go to 2001
c
       if(invers.eq.1) ix= -ix
       if(invers.eq.2) iy= -iy
       if(invers.eq.3) ix= -ix
       if(invers.eq.3) iy= -iy
       
       np=np+1
       
       if(np.gt.maxpt) go to 9000
c
c   scaling
c
       x(np)=float(ix)*scale
       y(np)=float(iy)*scale
       
       go to 2000

              
*---------------------------------------------------------------------72
*   start particle

2001   continue

       if(np.lt.minpt) go to 1999

*---------------------------------------------------------------------72
c   reduce no. of datapoints
c
       if(ireduce.ne.1) go to 549
       call reduce(x,y,np,xnew,ynew,npnew,mindist,distmin)
     
       do 550 i=1,npnew
       x(i)=xnew(i)
       y(i)=ynew(i)
550    continue
       np=npnew
549    continue


c
*---------------------------------------------------------------------72
c   complete outlines
c
       if(icmpl.eq.1) call complete(np,x,y,minpt)
       nnew=nnew+np+1
       
c
*---------------------------------------------------------------------72
c   smoothing
c
       if (ispli.eq.1) then
       
       call smout(x,y,np,xnew,ynew,digerr,iover,ireg)
       
       xnew(1)=0.5*(xnew(1)+xnew(np))
       ynew(1)=0.5*(ynew(1)+ynew(np))
       xnew(np)=xnew(1)
       ynew(np)=ynew(1)
       
       do i=1,np
       write(iunit2) xnew(i),ynew(i)
       enddo
       
       else

       do i=1,np
       write(iunit2) x(i),y(i)
       enddo

       end if

       write(iunit2) xend,yend

*---------------------------------------------------------------------72
*   end of particle

       go to 1999
       
*---------------------------------------------------------------------72
*   error in input

2099   continue
       print *,'end by error'
       
*---------------------------------------------------------------------72
2999   continue

       rewind(iunit2)
       close(unit=iunit1)
c
*---------------------------------------------------------------------72
c   write from scratch file into output file
c
10004  continue

*---------------------------------------------------------------------72
c   open output file
c
       open(unit=iunit1, file=bfil2, status='new',
     .      form='formatted', access='sequential')

*---------------------------------------------------------------------72
c   write


       write(iunit1,*) bti
       write(iunit1,*) nnew

       do 3000 i=1,nnew
       read(iunit2) xx,yy
       write(iunit1,*) xx,yy
3000   continue
       close(unit=iunit1)
       close(unit=iunit2)
*---------------------------------------------------------------------72
c   formats

5002   format(a)

*---------------------------------------------------------------------72
c   end of main program
c
       go to 9900
*---------------------------------------------------------------------72
9000   continue
       write(nlist,1020) maxpt
1020   format('>> particle larger than',i4,' points! program stopped.')
*---------------------------------------------------------------------72
9900   continue

       print *,' '
       end


*=============================================================
*   subroutine reduce
*
*    x,y       coordinates before
*    xn,yn     coordinates after
*    np        no. of coordinates before
*    npn       no. of coordinates after
*    mindist   0= zero 1=fine 2=medium 3=coarse 4=manual value: distmin
*    distmin   minimal distance (default=1.0, see main)

       subroutine reduce(x,y,np,xn,yn,npn,mindist,distmin)

       dimension x(1), y(1), xn(1), yn(1)

       dtest= distmin            !------- if mindist=4 distmin  0.00
       if (mindist.eq.4) go to 2

*----calculate length

       d=0.0
       do i=1,np-1
       i1=i
       i2=i+1
       x1= x(i2)-x(i1)
       y1= y(i2)-y(i1)
       d1= sqrt(x1*x1 + y1*y1)
       d=d+d1
       enddo

*----minimal distance: 10% of average line segment or 1% of total length

       factor=float(mindist)      !-------0 - 1 - 2 - 3

       dtest=factor*max((0.1*d/np),(0.01*d))
2      continue

*----check outline

       xn(1)=x(1)
       yn(1)=y(1)
       npn=1
       i2=1

1      continue

       i1=npn
       i2=i2+1
       if(i2.gt.np) go to 3

       xd= x(i2)-xn(i1)
       yd= y(i2)-yn(i1)
       dd= sqrt(xd*xd + yd*yd)
       if(dd.lt.dtest) go to 1

       npn=npn+1
       xn(npn)=x(i2)
       yn(npn)=y(i2)

       go to 1

3      continue

       return
       end


c
c*********************************************************************
c   subroutine complete
c
       subroutine complete(npin,x,y,minpt)
c
c   completes particle outline such that x(last)=x(1) and
c   y(last)=y(1); digitizing beyond endpoint is cut off.
c
       dimension x(1),y(1)
       np=npin
1      continue
       xd= x(np)-x(1)
       yd= y(np)-y(1)
       sc1= sqrt(xd*xd + yd*yd)
       xd= x(np-1)-x(1)
       yd= y(np-1)-y(1)
       sc2= sqrt(xd*xd + yd*yd)
       if(sc2.gt.sc1) go to 10
       np=np-1
       if(np.lt.minpt) go to 10
       go to 1
10     continue
       if(x(np).eq.x(1).and.y(np).eq.y(1)) go to 20
       np=np+1
       x(np)=x(1)
       y(np)=y(1)
20     continue
       npin=np
       return
       end
c
c*********************************************************************
c   subroutine smout
c
       subroutine smout(x,y,np,xnew,ynew,digerr,iover,ireg)
c
c   fits x- and y- spline through digitized points of particle outlines.
c   output: equally spaced x-y coordinates on smoothed outline.
c   if digerr is set 0.00 spline is forced through digitized points.
c
       dimension x(1),y(1),xnew(1),ynew(1),digerr(1)
c
c   see main program
c
       dimension s(2021),c(8084),w(10115)
c
c   s, c, w   arrays for splining calculations
c
c   dimensions: s( mdim )      mdim = maxpt+iover+iover+1
c               c( (mdim+2)*5 )
c               w( mdim*4 )
c
       dimension sreg(2000)
c
c   sreg   regularly spaced points on contour line
c   dimension: sreg( maxpt )
c
       nptemp=np-1
c
c   nptemp=np-1, since x(1)=x(np), i.e., only ntemp values are different
c
       intv=nptemp+iover+iover
c
c   add upper and lower extension
c
       if(iover.eq.0) go to 108
       do 100 i=1,nptemp
       j=i+iover
       xnew(j)=x(i)
       ynew(j)=y(i)
100    continue

       do 101 i=1,iover
       xnew(i)= xnew(i+nptemp)
       ynew(i)= ynew(i+nptemp)
       xnew(i+nptemp+iover)= xnew(i+iover)
       ynew(i+nptemp+iover)= ynew(i+iover)
101    continue

       do 102 i=1,intv
       x(i)=xnew(i)
       y(i)=ynew(i)
102    continue
c
c   find outline s
c
108    continue
       if(iover.eq.0) intv=np
       s(1)= 0.0000
       do 103 i=1,intv-1
       j=i+1
       xd= x(j)-x(i)
       yd= y(j)-y(i)
       s(j)=s(i)+ sqrt(xd*xd+yd*yd)
103    continue
c
c   determine outline sreg with regular/irregular intervals
c
       if(ireg.ne.1) go to 240
       sreg(1)=  s(iover+1)
       sreg(np)= s(iover+np)
       ds= (sreg(np)-sreg(1))/nptemp
       do 107 i=2,nptemp
       k=i-1
       sreg(i)= sreg(k)+ds
107    continue
240    continue
       if(ireg.ne.0) go to 241
       do 242 j=1,np
       i=j+iover
       sreg(j)=s(i)
242    continue
241    continue
c
c   start splines
c
c                 for x-coordinates
c
       call smos0(s,x,digerr,intv,c,w)
       do 104 i=1,np
       call smos1(s,intv,c,sreg(i),0,xnew(i))
104    continue
c
c                 for y-coordinates
c
       call smos0(s,y,digerr,intv,c,w)
       do 105 i=1,np
       call smos1(s,intv,c,sreg(i),0,ynew(i))
105    continue
       return
       end
c
c*********************************************************************
c   subroutine rang
c
      subroutine rang(irang,xint,x,nmin,nmax,ncod,ierr) 
      dimension x(200)   !   ist schon definiert
      data lup/5/
      if(xint-x(nmin))11,2,3
c
c   decreasing  x
c
11    if(xint-x(nmax))41,5,12 
12     na = nmax
      ne = nmin 
      irang = -1
      go to 10
c
c   increasing x
c
3     if(xint-x(nmax))4,5,1 
 4    na = nmin 
      ne = nmax 
       irang = 0
10    nd2 = (ne - na) / 2 
      if(nd2) 6,7, 6
6     na = na + nd2 
      if (xint- x(na))8,7,10
8     na = na -nd2
      ne = ne - nd2 
      go to 10
7     irang = na + irang
      ierr =0 
100    return 
2     irang = nmin
      ierr = -1 
      return
  5    irang = nmax 
      ierr =  1 
      return
1     if(x(nmin) - x(nmax)) 46,45,45
41    if(x(nmin) - x(nmax))45,46,46 
45    irang = nmin
      ierr=-1 
      go to 50
46    irang = nmax
      ierr= 1 
50    if( ncod -4 )100,60,60
   60 write(lup,1000) xint,nmin,x(nmin),nmax,x(nmax),irang
 1000 format(/,1x,'xint =',g10.2,5x,'is out of range'
     *,/1x,'nmin =',i5,6x,'x(nmin) =',g10.2,8x,'nmax ='
     *,i5,6x,'x(nmax)='
     *,g10.2,8x,'irang =',i5)
      if(ncod-8)100,100,70
70    call exit
      end 
c
c*********************************************************************
c
c
c  subroutine smos0
c
      subroutine smos0(x,y,yd,n,c,w)
      dimension x(2),y(2),yd(1),c(1),w(2) 
      s=n-1 
      seq=1.
      if(x(n).lt.x(1)) seq=-1.
      zwdr=2./3.
      dr=1./3.
      ir1=n+2 
      ir2=2*ir1 
      iu=3*ir1
      iv=4*ir1
      ib=n
      ic=2*n
      id=3*n
      m2=n+2
      n2=n+1
      w(1)=0. 
      w(2)=0. 
      i1=ir1+n2 
      w(i1)=0.
      i1=ir2+n2 
      w(i1)=0.
      w(i1+1)=0.
      w(iu+1)=0.
      w(iu+2)=0.
      i1=iu+n2
      w(i1)=0.
      i1=iu+m2
      w(i1)=0.
      p=0.
      m1=3
      m2=n
      h=x(2)-x(1) 
      f=(y(2)-y(1))/h   
      do 1 i=m1,m2
      g=h 
      h=x(i)-x(i-1) 
      e=f 
      f=(y(i)-y(i-1))/h 
      c(i-1)=f-e
      l=ir2+i 
      w(l)=yd(i-2)/g
      w(i)=yd(i)/h
      l=ir1+i 
      w(l)=-yd(i-1)/g-yd(i-1)/h 
1     continue
      do 2 i=m1,m2
      l=ib+i-1
      i1=ir1+i
      i2=ir2+i
      c(l)=w(i)*w(i)+w(i1)*w(i1)+w(i2)*w(i2)
      l=ic+i-1
      c(l)=w(i)*w(i1+1)+w(i1)*w(i2+1) 
      l=id+i-1
      c(l)=w(i)*w(i2+2) 
2     continue
      f2=-s 
c
c          begin iteration 
c
3     continue
      do 4 i=m1,m2
      i1=ir1+i-1
      i2=ir2+i-2
      w(i1)=f*w(i-1)
      w(i2)=g*w(i-2)
      l=ib+i-1
      w(i)=1./(p*c(l)+zwdr*(x(i)-x(i-2))-f*w(i1)-g*w(i2)) 
      l=iu+i
      w(l)=c(i-1)-w(i1)*w(l-1)-w(i2)*w(l-2) 
      l=ic+i-1
      f=p*c(l)+dr*(x(i)-x(i-1))-h*w(i1) 
      g=h 
      l=id+i-1
      h=c(l)*p
4     continue
      do 5 k=m1,m2
      i=m2+3-k
      l=iu+i
      i1=ir1+i
      i2=ir2+i
      w(l)=w(i)*w(l)-w(i1)*w(l+1)-w(i2)*w(l+2)
5     continue
      e=0 
      h=0 
      do 6 i=2,m2 
      g=h 
      l=iu+i
      h=(w(l+1)-w(l))/(x(i)-x(i-1)) 
      l=iv+i
      w(l)=(h-g)*yd(i-1)*yd(i-1)
      e=e+w(l)*(h-g)
6     continue
      l=iv+n+1
      g=-h*yd(n)*yd(n)  
      w(l)=g
      e=e-g*h 
      g=f2
      f2=e*p*p
      if(f2-s) 69,10,10 
69    if(f2-g) 10,10,7  
7     continue
      f=0.
      h=(w(iv+3)-w(iv+2))/(x(2)-x(1)) 
      do 8 i=m1,m2
      g=h 
      l=iv+i
      h=(w(l+1)-w(l))/(x(i)-x(i-1)) 
      l=ir1+i-1 
      i1=ir2+i-2
      g=h-g-w(l)*w(i-1)-w(i1)*w(i-2)
      f=f+g*w(i)*g
      w(i)=g
8     continue
      h=e-p*f 
      if(h) 10,10,9 
9     p=p+(s-f2)/((seq*sqrt(s/e)+p)*h)
      goto 3
c
c            end iteration 
c
10    continue
      do 11 i=1,n 
      l=iv+i+1
      c(i)=y(i)-p*w(l)  
      l=ic+i
      i1=iu+i+1 
      c(l)=w(i1)
11    continue
      m2=n-1
      do 12 i=1,m2
      h=x(i+1)-x(i) 
      l=id+i
      i1=ic+i 
      c(l)=(c(i1+1)-c(i1))/(3.*h) 
      i2=ib+i 
      c(i2)=(c(i+1)-c(i))/h-(h*c(l)+c(i1))*h
12    continue
      return
      end 
c
c*********************************************************************
c
c 
c   subroutine   s m o s 1                         ed.baumann 
c 
      subroutine smos1(xt,n,c,x,ic,y) 
      dimension xt(1),c(1)
      call rang(i,x,xt,1,n,0,ier) 
      if(ier) 3,3,2 
2     i=n-1 
3     z=x-xt(i) 
      ib=i+n
      ig=ib+n 
      id=ig+n 
      if(ic) 10,20,30   
10    y=(((c(id)*.25*z+c(ig)/3.)*z+c(ib)*.5)*z+c(i))*z
      if(i.eq.1) goto 99
      i1=i-1
      do 11 k=1,i1
      z=xt(k+1)-xt(k)   
      ib=k+n
      ig=ib+n 
      id=ig+n 
11    y=y+(((c(id)*.25+c(ig)/3.)*z+c(ib)*.5)*z+c(k))*z
      goto 99 
20    y=((c(id)*z+c(ig))*z+c(ib))*z+c(i)
      goto 99 
30    y=(3.*c(id)*z+c(ig)*2.)*z+c(ib) 
99    return
      end 
c
c*********************************************************************
c
        integer function mlen(s)
c
c       determine actual length of string s
c
        character *(*) s
        l=len(s)
        do 10 k=l,1,-1
        lg=k
        ivalue=ichar(s(k:k))
        if(.not.(ivalue.eq.32.or.ivalue.eq.0)) goto 99
   10   continue
        lg=0
   99   mlen=lg
        return
        end
c
c*********************************************************