*--------------------------------------------------------------------72
c   paror      par(ticle) or(ientation)
*--------------------------------------------------------------------72

c      bti                 (132 byte)
c      ntot                (1 integer)
c      x,y                 (2 real)
c      xend,yend           (2 real)

c   bti   header
c   ntot  number of x-y coordinate points stored in file
c   x,y   x-y coordinates of digitized contour lines

c   output files:
c   -printout     (e.g., ***.p10: printout with 10 deg. interval)
c   -B(alpha)     (e.g., ***.j10 : 10 deg. interval between points)
c                 (of projection function B)
c   -rose diagram (e.g., ***.x10 : 10 deg. interval between points)
c                 (of total length of long axes, = particle ODF)
c   -data file    (e.g., ***.d10 : list of axes, ratios, angles)
c
c***updated 20.6.2007, dec-02-2009
c***updated 7.11.2010 does Xc and Yc
c***updated 11.11.2010 does all axes and angles
c***updated 24.11.2010 all cleaned  -  sparor is now obsolete
c
       dimension x(1000), y(1000), r(1000)
       dimension xLA1(5000), xSA1(5000), xSA2(5000), xLA2(5000)
       dimension alfamin(5000), alfamax(5000)
       dimension ratio1(5000), ratio2(5000), ratio3(5000), ratio4(5000)
       dimension Xcenter(5000), Ycenter(5000)
c
c   x,y     coordinates of particle outlines
c   radius  vector for rotations
c   xLA1    longest axes of particles
c   xSA1    shortest axes of particles
c   xSA2    axes prpendicular to longest axes
c   xLA2    axes prpendicular to shortest axes
c   alfamax is orientation of LA1
c   alfamin is orientation of LA2 (NOT SA1 !!)
c   ratio1  log.10(xlong/xperp)
c   ratio2  log.nat.(xlong/xperp) (->rf-phi)
c   Xc,Yc   center point of particle (-> drawsxm)
c
       dimension proj(180), proj1(180)
       dimension star1(180), star2(180)
       dimension nstar1(180),nstar2(180),mstar1(180),mstar2(180)
       dimension nstar3(180),nstar4(180),mstar3(180),mstar4(180)
       dimension sum(3,180), stat(4,180), sum1(3,180),stat1(4,180)
c
c   proj  length of projection B
c
c   star1,star2,nstar1,nstar2,mstar1,mstar2
c         arrays for histograms of projection b
c   sum,stat
c         arrays for statistic of projection b
c
       dimension sLA1(3),sSA1(3),sSA2(3),sLA2(3)
       dimension tLA1(4),tSA1(4),tSA2(4),tLA2(4)
       dimension sba1(3),sba2(3),tba1(4),tba2(4)
       dimension sba3(3),sba4(3),tba3(4),tba4(4)
c
c   sxLA1,txLA2   sum and statistics of long axes
c   sxSA1,txSA2   sum and statistics of short axes
c   sxSA2,txSA2   sum and statistics of perpendicular to longest
c   sxLA2,txLA2   sum and statistics of perpendicular to shortest
c   sba1,tba1   sum and statistics of ratio ba1: SA2 / LA1
c   sba2,tba2   sum and statistics of ratio ba2: SA1 / LA1
c   sba3,tba3   sum and statistics of ratio ba3: SA1 / LA2
c   sba4,tba4   sum and statistics of ratio ba4: SA2 / LA2
c
       dimension xlong(180),xlong2(180),nlong(180),nlong2(180)
       dimension xhist(180),xhist2(180)
       dimension axhist(180),axhist2(180),nxhist(180),nxhist2(180)
c
c   xlong, xhist, axhist  arrays for average length of axes per angle
c   nlong, nhist, nxhist  arrays for number of long axes per angle
c
       character*20 bfil, bout, bspl, bros, bdat, btemp
       character histo*100, bti*132, b1*40, b2*40
       character*1 qhis, qstd
       character*1 stars,blank,plus,colon
       data lbyte/132/
       data lowax,lhis/-180,30/
       data minpt,maxpt,mxpart,mxdim,incmin/3,1000,5000,180,1/
       data iunit1,ncard,nlist,lenhis/1,5,6,60/
       data stars,blank,plus,colon,qstd/'*',' ','+',':','y'/

*--------------------------------------------------------------------72
c   ask information
c
10001  continue
       write(nlist,1001) maxpt,mxpart
1001   format(
     . ' -----------------------------------------------------------'/
     . ' ***  paror  ***                              2010-11-24, rh'/
     . ' -----------------------------------------------------------'/
     . ' analysis of bulk particle fabric'/
     . ' maximum number of points per particles is ',i4,/
     . ' maximum number of particles is ',i4/
     . ' -----------------------------------------------------------'/
     . ' input file:'/
     . '    line 1:            bti(132byte) title (must have)'/
     . '    line 2:            n            total number of points'/
     . '    for each particle: x,y          floating x-y coordinates'/
     . '    |                  ...          ...etc.'/
     . '    |                  Xend,Yend    end coordinates'/
     . ' -----------------------------------------------------------')

10010  write (nlist,1020)
1020    format(' name of file > ')
       read(ncard,5005,err=10010) bfil

       write(nlist,1032)
1032   format
     . ('end coordinate of input file (0, 9999, ... one number): ')
       read(ncard,*) xend
       yend=xend

       write(nlist,1004) incmin
1004   format (' increment of rotation angle (minimum:',i2,' deg.) > ')
       read (ncard,*) incr

       write(nlist,1008)
1008   format(' do you want printout (0), file (1), both (2) ? > ')
       read(ncard,*) iprint
       if(iprint.eq.0) go to 1
c
*--------------------------------------------------------------------72
c   other file names
c
       bout=bfil
       bspl=bfil
       bros=bfil
       bdat=bfil
       ml=mlen(bfil)
       write(bout(ml-2:),'(a,i2.2)') 'p',incr
       write(bspl(ml-2:),'(a,i2.2)') 'j',incr
       write(bros(ml-2:),'(a,i2.2)') 'x',incr
       write(bdat(ml-2:),'(a,i2.2)') 'd',incr

*--------------------------------------------------------------------72
c   verify
c
       write(nlist,1009) bout(1:ml)
1009   format(' name of printout file ? [',a,'] (return=default) > ')
       read(ncard,5005) btemp
       if(mlen(btemp).ne.0) bout=btemp
       write(nlist,1010) bspl(1:ml)
1010   format(' name of file with B(alfa) curve ? [',a,'] > ')
       read(ncard,5005) btemp
       if(mlen(btemp).ne.0) bspl=btemp
       write(nlist,1011) bros(1:ml)
1011   format(' name of file with long-axes ODF ? [',a,'] > ')
       read(ncard,5005) btemp
       if(mlen(btemp).ne.0) bros=btemp
       write(nlist,1013) bdat(1:ml)
1013   format(' name of file with particle data ? [',a,'] > ')
       read(ncard,5005) btemp
       if(mlen(btemp).ne.0) bdat=btemp
1      continue

*--------------------------------------------------------------------72
c   open file 
c
       open(unit=iunit1, file=bfil,status='old',
     .      form='formatted', access='sequential')

c   start calculations
c
       read (iunit1,5005) bti(1:60)
       write (nlist,5007) bfil(1:ml)
       write (nlist,5008) bti(1:60)
5007   format('opening file: ',a)
5008   format('header:  ',a)
c
c   formats
c
5000   format(2i5)
5001   format(2f12.5)
5003   format(f12.1,2f12.5)
5005   format(a)
5006   format(i5,f12.5)
5009   format(6f12.5)
c
c   starting conditions
c
       mincr= mxdim/incr
       mincx= mxdim/incr
       np=1
       n9=0
       nppar=0
       nppar1=0
       numr=0
       nxLA1=0
       nxSA1=0
       nxSA2= 0
       nxLA2= 0
       nba1=0
       nba2=0
       nba3=0
       nba4=0
       jo=0
       do 2 i=1,3
       sLA1(i)=0.
       sSA1(i)=0.
       sSA2(i)=0.
       sLA2(i)=0.
       sba1(i)=0.
       sba2(i)=0.
       sba3(i)=0.
       sba4(i)=0.
      do 2 ii=1,mxdim
       sum(i,ii)=0.
       sum1(i,ii)=0.
2      continue
c
*--------------------------------------------------------------------72
c   segmented input: start
c
       read (iunit1,*) ntot
       i=0
500    continue
       call seginp(nlist,iunit1,i,np,x,y,ntot,
     .              maxpt,minpt,icont,xend)
c
c   icont=1: particle too small or too large
c   icont=2: i > ntot (all points are used)
c
       if(icont.eq.1) go to 400
       if(icont.eq.2) go to 501
c
c   projection with increment = 1 to get min max and b/a
c
       call axproj(x,y,np,1,proj1,axLA1,axSA1,axSA2,axLA2,
     .             alfmax,alfmin,r,Xc,Yc)
       call dsum2(proj1,180,sum1,nppar1)
c
c   projection with increment incr
c
       call axproj(x,y,np,incr,proj,axLA1,axSA1,axSA2,axLA2,
     .             alfmax,alfmin,r,Xc,Yc)
c
c   statistics
c
       call dsum2(proj,mincr,sum,nppar)
       
       call dsum(axLA1,sLA1,nxLA1)
       call dsum(axSA1,sSA1,nxSA1)
       call dsum(axSA2,sSA2,nxSA2)
       call dsum(axLA2,sLA2,nxLA2)
       
       ba1= axSA2/axLA1
       ba2= axSA1/axLA1
       ba3= axSA1/axLA2
       ba4= axSA2/axLA2
       call dsum(ba1,sba1,nba1)
       call dsum(ba2,sba2,nba2)
       call dsum(ba3,sba3,nba3)
       call dsum(ba4,sba4,nba4)
       
       numr=numr+1
       
       xLA1(numr)= axLA1
       xSA1(numr)= axSA1
       xSA2(numr)= axSA2
       xLA2(numr)= axLA2
       
       ratio1(numr)= ba1
       ratio2(numr)= ba2
       ratio3(numr)= ba3
       ratio4(numr)= ba4
       
       alfamax(numr)= alfmax
       alfamin(numr)= alfmin
       
       Xcenter(numr)= Xc
       Ycenter(numr)= Yc
c
*--------------------------------------------------------------------72
c    segmented input: end
c
400    np=1
       n9= n9+1
       go to 500
501    continue

       close(unit=iunit1)
       
       if(nppar.le.1) go to 8100
c
c    complete statistics
c
       call term2(mincr,sum,nppar,stat)
       call term2(180,sum1,nppar1,stat1)
*       print *,(stat1(1,i),i=1,180)
       
c
*--------------------------------------------------------------------72
c    find B(alfa)min B(alfa)max and alfamin and alfamax
c
       balfamin= 99999.
       balfamax= - balfamin
       
       do i=1,180
       balfamin= amin1(balfamin,stat1(1,i))
       balfamax= amax1(balfamax,stat1(1,i))
       enddo
       
       do 1200 i=1,180
       if(stat1(1,i).ne.balfamax) go to 1199
       imax=i
       alfamaxB=float(imax)
1199   if(stat1(1,i).ne.balfamin) go to 1200
       imin=i
       alfaminB=float(imin)
1200   continue

       Bmax= stat1(1,imax)
       Bmin= stat1(1,imin)
       aniso= Bmin/Bmax
       
       if (alfamaxB.gt.alfaminB) diffalfa = alfamaxB-alfaminB
       if (alfamaxB.lt.alfaminB) diffalfa = alfamaxB+180.-alfaminB
       
*--------------------------------------------------------------------72
       write(nlist,3001) Bmin,Bmax
3001   format(/'B(alfa)min =',t18,f10.3,t40,
     . 'B(alfa)max =',t56,f10.3)
       write(nlist,3003) alfaminB, alfamaxB
3003   format('Alfamin =',t15,f10.0,t40,'Alfamax =',t53,f10.0)
       write(nlist,3002) aniso 
3002   format('Bulk b/a =',t26,f10.5)
       write(nlist,3004) diffalfa 
3004   format('Angular difference =',t21,f10.0)
       write(nlist,3005)
3005   format('(diff < 90 deg = dextral monoclinic)'/)
       alfap2= 90.-alfaminB
       alfap1= 180.-alfamaxB
       write(nlist,3006) alfap1, alfap2
3006   format('Preferred orientation (of LA1) alfap1 = ', f6.0/
     .        'Preferred orientation (of LA2) alfap2 = ', f6.0)       
c
c    complete statistics II
c
       call term(sLA1,nxLA1,tLA1)
       call term(sSA1,nxSA1,tSA1)
       call term(sSA2,nxSA2,tSA2)
       call term(sLA2,nxLA2,tLA2)
       
       call term(sba1,nba1,tba1)
       call term(sba2,nba2,tba2)
       call term(sba3,nba3,tba3)
       call term(sba4,nba4,tba4)
c
c   histogram of mean of length of projection and 
c   standard deviation
c
       do 10 i=1,mincr
       star1(i)= stat(1,i)
       star2(i)= stat(3,i)
10     continue

       call stard(star1,star2,mincr,lenhis,nstar1,nstar2)
c
*--------------------------------------------------------------------72
c   create o.d.f. of long axes
c
       do 4 i=1,mxdim
       xlong(i)=0.
       nlong(i)=0
       xlong2(i)=0.
       nlong2(i)=0
4      continue

       do 5 i=1,numr
       
       is=i
       in= ifix(alfamax(is))
       if(in.eq.0) in=180
       in2= ifix(alfamin(is))
       if(in2.eq.0) in2=180
       
       xlong(in)= xlong(in) + xLA1(is)
       nlong(in)= nlong(in) + 1
       xlong2(in2)= xlong2(in2) + xLA2(is)
       nlong2(in2)= nlong2(in2) + 1
5      continue

       do 6 i=1,mincx
       xsum=0.
       nsum=0
       xsum2=0.
       nsum2=0
       jm= i
       do 7 j=1,incr
       ini= j+(jm-1)*incr
       xsum=xsum + xlong(ini)
       nsum=nsum + nlong(ini)
       xsum2=xsum2 + xlong2(ini)
       nsum2=nsum2 + nlong2(ini)
7      continue

       axhist(i)= xsum
       nxhist(i)= nsum
       axhist2(i)= xsum2
       nxhist2(i)= nsum2
6      continue

       do 98 i=1,mincx
       xhist2(i)=0.
       if(nxhist2(i).eq.0) go to 98
       xhist2(i)= axhist2(i)/float(nxhist2(i))
98      continue

       do 8 i=1,mincx
       xhist(i)=0.
       xhist2(i)=0.
       if(nxhist(i).eq.0) go to 88
       xhist(i)= axhist(i)/float(nxhist(i))
88     if(nxhist2(i).eq.0) go to 8
       xhist2(i)= axhist2(i)/float(nxhist2(i))
8      continue

       call star(xhist,mincx,lhis,mstar1)
       call stari(nxhist,mincx,lhis,mstar2)
       call star(xhist2,mincx,lhis,mstar3)
       call stari(nxhist2,mincx,lhis,mstar4)
c
*--------------------------------------------------------------------72
c       print results on terminal
c   (1) projections
c
       if(iprint.eq.1) go to 8000
       write(nlist,701) bfil
701    format(/' paror analysis of ',a/
     .         ' ------------------------------------------------'/)
702    format(/' evaluation of particles'/)
704    format(/' number of projected particles: ', i5)
       write(nlist,705)
705    format(/' length of projections, B(alpha), (= Feret diam.)'/
     .  /' angle', t18,'mean', t28, 'variance', t44,
     . 'st.dev.', t56, 'skewness'/)
       do 11 i=1,mincr
       jincr=i*incr
       write(nlist,706) jincr, (stat(ii,i),ii=1,4)
11     continue
706    format(i6,3x,4f14.5)
c
c   histogram of b(alpha)
c
       write(nlist,710)
710    format(/' histogram: average length of projection',
     .           ' versus angle of projection'/)
       do 12 i=1,mincr
       jstar=nstar1(i)
       kstar=nstar2(i)
       jincr=i*incr
       if(kstar.gt.lenhis) kstar= lenhis
       do 13 ko=1,jstar
       histo(ko:ko)=stars
       if(kstar.gt.jstar.and.(qstd.eq.'y'.or.qstd.eq.'y'))
     .                     histo(ko:ko)= plus
13     continue
       if(qstd.eq.'n') go to 14
       low=1
       if(kstar.gt.jstar) low = jstar+1
       do 15 ko=low,kstar
       histo(ko:ko)=colon
15     continue
14     continue
       write(nlist,711) jincr,(histo(ko:ko),ko=1,jstar)
711    format(i5,2x,100a1)
12     continue
       write(nlist,721)
c
*--------------------------------------------------------------------72
c   (2) particle axes etc.
c
       write(nlist,712) 
712    format(/' evaluation of particle axes:'/
     .         '-----------------------------')
       write(nlist,704) nppar
       write(nlist,713)
713    format(/' ', t30,'mean', t37, 'variance', t49,
     . 'st.dev.', t59, 'skewness')
       write(nlist,714) (tLA1(i),i=1,4)
714    format(/' longest projection',t23,4f11.4)
       write(nlist,715) (tSA1(i),i=1,4)
715    format(' shortest projection',t23,4f11.4)
       write(nlist,716) (tSA2(i),i=1,4)
716    format(' perp. to longest',t23,4f11.4)
       write(nlist,796) (tLA2(i),i=1,4)
796    format(' perp. to shortest',t23,4f11.4/)
       write(nlist,717) (tba1(i),i=1,4)
717    format(' perp.L/longest',t23,4f11.4)
       write(nlist,718) (tba2(i),i=1,4)
718    format(' shortest/longest',t23,4f11.4/)
       write(nlist,787) (tba3(i),i=1,4)
787    format(' shortest/perp.S',t23,4f11.4)
       write(nlist,788) (tba4(i),i=1,4)
788    format(' perp.L/perp.S',t23,4f11.4/)

       write(nlist,719)
719    format(/' histogram of long axes and number of long axes LA1',
     . ' versus angle of rotation'//
     . ' ',t13,'average length of long axes:',t55,
     . 'number of long axes:'/)
c
c   create histograms  for sum LA1 and no.LA1
c
       do 27 ij=1,mincx
       i= ij
       j= mstar1(i)
       jj=mstar2(i)
       do 28 k=1,lhis+1
       b1(k:k)= blank
       b2(k:k)= blank
28     continue
       do 29 k=1,j
       b1(k:k)= stars
29     continue
       do 30 k=1,jj
       b2(k:k)= stars
30     continue
       write(nlist,720) xhist(i),i*incr,b1(1:lhis+1),
     .                   nxhist(i),i*incr,b2(1:lhis+1)
27     continue
       write(nlist,721)
c
c   create histograms  for sum LA2 and no.LA2
c
       write(nlist,819)
819    format(/' histogram of long axes and number of long axes LA2',
     . ' versus angle of rotation'//
     . ' ',t13,'average length of long axes:',t55,
     . 'number of long axes:'/)

       do 127 ij=1,mincx
       i= ij
       j= mstar3(i)
       jj=mstar4(i)
       do 128 k=1,lhis+1
       b1(k:k)= blank
       b2(k:k)= blank
128     continue
       do 129 k=1,j
       b1(k:k)= stars
129     continue
       do 130 k=1,jj
       b2(k:k)= stars
130     continue
       write(nlist,720) xhist2(i),i*incr,b1(1:lhis+1),
     .                   nxhist2(i),i*incr,b2(1:lhis+1)
127     continue
       write(nlist,721)

720    format(f7.2,1x,i3,1x,a,3x,i3,1x,i3,1x,a)
721    format(/)
c
*--------------------------------------------------------------------72
c   create output files
c
       if(iprint.eq.0) go to 9000
8000   continue
c
*--------------------------------------------------------------------72
c   file ***.d..: list of axes, ratios, angles
c
       open(unit=iunit1,file=bdat,status='new',
     .       form='formatted',access='sequential')
       write(iunit1,701) bfil
       write(iunit1,722)
722    format(' ------------------------------------------------'/)
       write(iunit1,802) numr
802    format(' number of particles: ', i5/)
       write(iunit1,803) minpt,maxpt,incr
803    format(' minimum number of points/particle : ',i5/
     .        ' maximum number of points/particle : ',i5/
     .        ' increment of rotation :             ',i5/)
     
       write(iunit1,804)
804    format(/' #  longest(LA1)  shortest(SA1) ',
     .  ' perp.L(SA2)   perp.S(LA2)  SA2/LA1   SA1/LA1 ',
     .  ' alfaLA1   alfaLA2    mkl     Xc     Yc'/)
     
       do 3 i=1,numr
       
       alf1 = alfamax(i)
       alf2 = alfamin(i)
       xmonoclin = alf1-alf2
       if(xmonoclin.gt.90.)  xmonoclin=xmonoclin-180
       if(xmonoclin.lt.-90.) xmonoclin=180+xmonoclin
            
       
       write(iunit1,805) i,xLA1(i),xSA1(i),xSA2(i),xLA2(i),ratio1(i),
     .  ratio2(i),alfamax(i),alfamin(i),xmonoclin,Xcenter(i),Ycenter(i)
3      continue
805    format(i5,6f12.4,3f10.0,2f10.2)

       close(unit=iunit1)

       print *,'finished file  ',bdat
c
*--------------------------------------------------------------------72
c   file ***.p.. = terminal output
c
       open(unit=iunit1,file=bout,status='new',
     .       form='formatted',access='sequential')
       write(iunit1,701) bout
       
       write(iunit1,3001) Bmin,Bmax
       write(iunit1,3003) alfaminB, alfamaxB
       write(iunit1,3002) aniso 
       write(iunit1,3004) diffalfa 
       write(iunit1,3005)
       write(iunit1,3006) alfap1, alfap2
       
       write(iunit1,705)
       do 17 i=1,mincr
       jincr=i*incr
       write(iunit1,706) jincr, (stat(ii,i),ii=1,4)
17     continue

c
c   histograms
c
       write(iunit1,710)
       do 18 i=1,mincr
       jstar=nstar1(i)
       kstar=nstar2(i)
       jincr=i*incr
       if(kstar.gt.lenhis) kstar= lenhis
       do 19 ko=1,jstar
       histo(ko:ko)=stars
       if(kstar.gt.jstar.and.(qstd.eq.'y'.or.qstd.eq.'y'))
     .                     histo(ko:ko)= plus
19     continue
       if(qstd.eq.'n') go to 20
       low=1
       if(kstar.gt.jstar) low = jstar+1
       do 21 ko=low,kstar
       histo(ko:ko)=colon
21     continue
20     continue
       write(iunit1,711) jincr,(histo(ko:ko),ko=1,jstar)
18     continue

       write(iunit1,721)
c
c   continue to create output
c
       write(iunit1,712)
       write(iunit1,704) nppar
       write(iunit1,713)
       write(iunit1,714) (tLA1(i),i=1,4)
       write(iunit1,715) (tSA1(i),i=1,4)
       write(iunit1,716) (tSA2(i),i=1,4)
       write(iunit1,796) (tLA2(i),i=1,4)
       write(iunit1,717) (tba1(i),i=1,4)
       write(iunit1,718) (tba2(i),i=1,4)
       write(iunit1,787) (tba3(i),i=1,4)
       write(iunit1,788) (tba4(i),i=1,4)

       write(iunit1,719)
       
       do 23 ij=1,mincx
       i= ij
       j= mstar1(i)
       jj=mstar2(i)
       do 24 k=1,lhis+1
       b1(k:k)= blank
       b2(k:k)= blank
24     continue
       do 25 k=1,j
       b1(k:k)= stars
25     continue
       do 26 k=1,jj
       b2(k:k)= stars
26     continue
       write(iunit1,720) xhist(i),i*incr,b1(1:lhis+1),
     .                   nxhist(i),i*incr,b2(1:lhis+1)
23     continue

       write(iunit1,819)
       
       do 123 ij=1,mincx
       i= ij
       j= mstar3(i)
       jj=mstar4(i)
       do 124 k=1,lhis+1
       b1(k:k)= blank
       b2(k:k)= blank
124     continue
       do 125 k=1,j
       b1(k:k)= stars
125     continue
       do 126 k=1,jj
       b2(k:k)= stars
126     continue
       write(iunit1,720) xhist(i),i*incr,b1(1:lhis+1),
     .                   nxhist(i),i*incr,b2(1:lhis+1)
123     continue

       write(iunit1,721)
       
       close(unit=iunit1)
       
       print *,'finished file  ',bout
c
*--------------------------------------------------------------------72
c    ***.j.. = spline-input file
c
       open(unit=iunit1,file=bspl,status='new',
     .       form='formatted',access='sequential')
     
       write(iunit1,727) 
727    format(' angle   relative_length_of_projection')   

       statmax=0.00
       
       do 40 i=1,mincr
       jincr=i*incr
       statmax=amax1(statmax,stat(1,i))
40     continue
       
       write(iunit1,5006) 0,stat(1,mincr)/statmax

       do 41 i=1,mincr
       jincr=i*incr
       stat(1,i)=stat(1,i)/statmax
       write(iunit1,5006) jincr,stat(1,i)
41     continue

       close(unit=iunit1)

       print *,'finished file  ',bspl
c
*--------------------------------------------------------------------72
c   ***.x.. = odf of long axes
c
       open(unit=iunit1,file=bros,status='new',
     .       form='formatted',access='sequential')
       
       write(iunit1,725) 
725    format(' angle   rel_length_LA1  rel_length_LA2')       
c
c   for odf: xhist (=average length) * nxhist (number of axes per angle)
c
       axmax=0.00
       axmax2=0.00
       
       do  i=1,mincx
       l=i*incr
       ax=xhist(i)*float(nxhist(i))
       axmax=amax1(axmax,ax)
       ax2=xhist2(i)*float(nxhist2(i))
       axmax2=amax1(axmax2,ax2)
       enddo

       xangle=-180.
       ax=xhist(mincx)*float(nxhist(mincx))
       axrel=ax/axmax
       ax2=xhist2(mincx)*float(nxhist2(mincx))
       axrel2=ax2/axmax2
       write(iunit1,5003) xangle,axrel,axrel2

       do 32 i=1,mincx
       
       l=lowax+i*incr
       
       xangle=float(l)-0.5*float(incr)
       ax=0
       write(iunit1,5003) xangle,ax,ax
       
       xangle=float(l)
       
       ax=xhist(i)*float(nxhist(i))
       axrel=ax/axmax
       ax2=xhist2(i)*float(nxhist2(i))
       axrel2=ax2/axmax2
       write(iunit1,5003) xangle,axrel,axrel2
       
32     continue

       do 33 i=1,mincx
       
       l=i*incr

       xangle=float(l)-0.5*float(incr)
       ax=0
       write(iunit1,5003) xangle,ax,ax
       
       xangle=float(l)
       
       ax=xhist(i)*float(nxhist(i))
       axrel=ax/axmax
       ax2=xhist2(i)*float(nxhist2(i))
       axrel2=ax2/axmax2
       write(iunit1,5003) xangle,axrel,axrel2

33     continue

       close(unit=iunit1)
       
       print *,'finished file  ',bros
       print *,' '
c
       go to 9000
c
c   end
c
8100   continue
       write(nlist,8001) bfil
8001   format(/' the file ',a)
       write(nlist,8002) ntot
8002   format(' consists of an unsegmented string of characters
     . of length ',i6/
     . ' no calculation is carried out.'/)
9000   continue
       end

*====================================================================72
*--------------------------------------------------------------------72
c   subroutine seginp
c
       subroutine seginp(iuni1,iuni2,i,np,x,y,ntot,
     .                    maxpt,minpt,icont,xend)
c
c   iuni1  (i)   unit number of terminal
c   iuni2  (i)   unit number of file
c   i      (i/o) counter of total no.of coordinate points
c                at start, set i=0
c   np     (  o) counter of no.of points per particle
c   x      (  o) x-coordinates
c   y      (  o) y-coordinates
c   ntot   (i  ) total no.of coordinate points
c   maxpt  (i  ) max.no.of points per particle
c   minpt  (i  ) minimum no.of points per particle
c   icont  (  o) flag for termination of seginp
c
       dimension x(1),y(1)
       icont=0
       np=1
c
c   start reading coordinates of one particle
c
1      continue
       i=i+1
       if(i.le.ntot) go to 300
       icont= 2
       go to 9999
300    continue
       read (iuni2,*) xx,yy
       if(xx.eq.xend) go to 400
       x(np)= xx
       y(np)= yy
       np= np+1
       if(np.gt.maxpt) go to 998
       go to 1
c
c   points of one particle are collected
c
400    np=np-1
       if(np.le.minpt) go to 999
       go to 9999
c
c   particle too large
c
998    continue
       write(iuni1,1001)
1001   format(' particle with too many points discarded')
c
c    read remaining coordinates of particle
c
600    continue
       i=i+1
       read(iuni2,*,end=601) xx,yy
       if(xx.ne.xend) go to 600
601    continue
       icont= 1
       go to 9999
c
c   particle too small
c
999    continue
       if(np.lt.1) go to 700
       write(iuni1,1002)
1002   format(' particle with too few points discarded')
700    continue
       icont= 1
9999   continue
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine dsum
c
       subroutine dsum (x, d, n)
       dimension d(3)
       ie=3
       if(abs(x).lt.0.00001) ie = 2
       do 100 i=1,ie
100    d(i)= d(i) + x**i
       n= n+1
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine term
c
       subroutine term (d, n, st)
       dimension d(3), st(4)
       st(2)= 0.0000
       st(3)= 0.0000
       st(4)= 0.0000
       st(1)= d(1)/n
       if (n.le.1) go to 4000
       st(2)= (d(2)-(d(1)*d(1)/n))/(n-1)
       fract=st(2)
       if(st(1).ne.0.) fract=fract/st(1)
       if(fract.lt.1.e-06.or.st(2).le.0.) go to 50
       st(3)= sqrt(st(2))
50     continue
       if(st(3).eq.0.) go to 4000
       do 70 i=1,3
70     d(i)= d(i)/n
       sss=st(3)*st(3)*st(3)
       st(4)= (d(3) -3.*d(1)*d(2) +2.*d(1)*d(1)*d(1))/ sss
4000   return
       end
c
*--------------------------------------------------------------------72
c   subroutine dsum2
c
       subroutine dsum2(x,m,t,n)
       dimension x(m), t(3,m)
       do 100 i2= 1,m
       ie=3
       if(abs(x(i2)).lt.0.00001) ie= 2
       do 100 i1= 1,ie
       t(i1,i2)= t(i1,i2) +  x(i2)**i1
100    continue
       n= n+1
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine term2
c
       subroutine term2 (m, t, n, tt)
       dimension t(3,m), tt(4,m)
       do 99 i=1,m
       tt(2,i)= 0.0000
       tt(3,i)= 0.0000
       tt(4,i)= 0.0000
99     continue
       do 100 i= 1,m
       tt(1,i)= t(1,i)/n
       if (n.le.1) go to 100
       tt(2,i)= (t(2,i)-t(1,i)*t(1,i)/n)/(n-1)
       fract=tt(2,i)/tt(1,i)
       if(fract.lt.1.e-06) go to 50
       tt(3,i)= sqrt(tt(2,i))
50     continue
       if(tt(3,i).eq.0.) go to 100
       do 101 ii=1,3
101    t(ii,i)= t(ii,i)/n
       ttt= tt(3,i)*tt(3,i)*tt(3,i)
       tt(4,i)= (t(3,i)-3.*t(1,i)*t(2,i)+2.*t(1,i)*t(1,i)*t(1,i))/ttt
100    continue
       return
       end
c
*--------------------------------------------------------------------72
c   subroutine axproj
c
       subroutine axproj
     . (x,y,nx,incr,proj,axlo,axsh,ax90,axlo2,an,an2,r,Xc,Yc)
c   
c   calculates longest, shortest axis and axis perpendicular to
c   long axis.
c   evaluates angle of long axis
c** NOTE: not the same axproj as in sparor !!
c   an = alfamax is orientation of LA1
c   an2 = alfamin is orientation of LA2 (NOT SA1 !!)
c
       dimension x(1), y(1), proj(1), r(1)
       data pi,piha,pi2,factor/3.141596254,1.570796327,6.283185308,
     .       0.0174532925/
       sumx=0.0
       sumy=0.0
       do 240 i=1,nx
       r(i)= sqrt(x(i)*x(i) + y(i)*y(i))
       sumx=sumx+x(i)
       sumy=sumy+y(i)
240    continue
       Xc=sumx/float(nx)
       Yc=sumy/float(nx)
       mincr=180/incr

       do 250 j=1,mincr
       xpmin= 999999.
       xpmax=-xpmin
       do 230 i=1,nx
       bet=piha
       if(x(i).ne.0.) bet= atan(y(i)/x(i))
       if(x(i).lt.0.) bet= bet+pi
       if(bet.lt.0.)  bet= bet+ pi2
       beta= bet + float(j*incr)*factor
       xp= r(i)*cos(beta)
       xpmin= amin1(xpmin,xp)
       xpmax= amax1(xpmax,xp)
230    continue
       proj(j)= xpmax- xpmin
250    continue
       axlo= -999999.
       axsh= -axlo
       
       do 300 imi=1,mincr
       i= imi
       axlo= amax1(axlo,proj(i))
       axsh= amin1(axsh,proj(i))
300    continue

       do 301 li= 1,mincr
       if(axlo.ne.proj(li)) go to 301
       ilong= li
       an= 180.-float(ilong*incr)
       if(an.lt.0.) an = an+180.   ! insert as in sparor
301    continue

       ih= 90/incr

       if(ilong.gt.ih)  ih= -ih
       i90= ilong+ih
       ax90= proj(i90)

       do 302 li= 1,mincr
       if(axsh.ne.proj(li)) go to 302
       ishort= li
       an2= 90.-float(ishort*incr)
       if(an2.lt.0.) an2 = an2+180.   ! insert as in sparor
302    continue

       ih= 90/incr

       if(ishort.gt.ih)  ih= -ih
       i90= ishort+ih
       axlo2= proj(i90)


       return
       end
c
*--------------------------------------------------------------------72
c   subroutine star
c
        subroutine stard(rphi, sphi, mfang, laeng, nstarr, nstars)
        dimension rphi(mfang), nstarr(mfang)
       dimension sphi(mfang), nstars(mfang)
        rmax= 0.
       do 99 i=1,mfang
       nstarr(i)=0
       nstars(i)=0
99     continue
        do 100 j=1,mfang
  100   rmax= amax1 (rphi(j), rmax)
       if(rmax.eq.0) go to 102
        do 101 j=1,mfang
        nstarr(j)= ifix (float(laeng)* rphi(j)/ rmax)
       nstars(j)= ifix (float(laeng)* sphi(j)/ rmax)
101    continue
102    return
        end

*--------------------------------------------------------------------72
c   subroutine star
c
        subroutine star (rphi, mfang, laeng, nstarr)
        dimension rphi(mfang), nstarr(mfang)
        rmax= 0.
       do 99 i=1,mfang
       nstarr(i)=0
99     continue
        do 100 j=1,mfang
  100   rmax= amax1 (rphi(j), rmax)
       if(rmax.eq.0) go to 102
       do 101 j=1,mfang
        nstarr(j)= ifix (float(laeng)* rphi(j)/ rmax)
101    continue
102    return
       end

*--------------------------------------------------------------------72
c   subroutine stari
c
      subroutine stari (nphi, mfang, laeng, nstar)
      dimension nphi(mfang), nstar(mfang)
      nmax= 0.
      do 100 j=1,mfang
  100 nmax= max0 (nphi(j), nmax)
      do 101 j=1,mfang
  101 nstar (j)= ifix(float(laeng)* float(nphi(j))/float(nmax))
      return
      end
c
*--------------------------------------------------------------------72
       integer function mlen(s)
c
c      determine actual length of string s
c
       character *(*) s
       l=len(s)
       do 10 k=l,1,-1
       lg=k
       ivalue=ichar(s(k:k))
       if(.not.(ivalue.eq.32.or.ivalue.eq.0)) goto 99
   10  continue
       lg=0
   99  mlen=lg
       return
       end
c
