*---------------------------------------------------------------------72
*   ishapesPure
*---------------------------------------------------------------------72
*     NEW deltP  now as (P-PE)/P   different from PARIS
*---------------------------------------------------------------------72
*     angle output corrected. 
*     is now (np-1) angles because np is true number of points +1
*     because first and last are the same.
*---------------------------------------------------------------------72
*     also calculates absolute angles and 'both sides' of angle
*---------------------------------------------------------------------72
*   shape analysis of i-ndividual particles

*   axial ratios:
*   longest projection xL
*   shortest projection xS
*   projection perpendicular to longest xPL
*   projection perpendicular to shortest xPS

*   shape factors:
*   perimeter length
*   area of particle
*   envelope length
*   area of envelope

*   angles:
*   angles at vertices of polygons
*   length / rel. length of line segments
*   absolute angles
*   combined length of both lines meeting at each vertex

*
*   input file:
*   bti   (132 byte)        header
*   ntot  (integer)         number of x-y coordinate points stored in file
*   x,y   (real or integer) x-y coordinates of digitized contour lines

*   output:
*   - printed results on terminal
*   - list of results for all grains(i)
*
*      b_infile      name of segmented input file
*      b_newcoord    name of output file: new coordinates
*      b_angles      name of output file: table of all angles
*      b_shapes      name of output file: shape factors of all grains
*      b_envel       name of output file: envelope of all grains

*      graina(4000)  vector to hold angles of one grain
*      grainl(4000)  vector to hold lengths of one grain

*---------------------------------------------------------------------72
*  convex hull (subroutine envelope) re-written 1.12.2009
*  update 17-09-2010
*  update 28.10.2010 rh subroutine bproj
*     last update Mar-06 2012
*---------------------------------------------------------------------72
       program ishapes

       character*100 b_infile, b_angles, b_shapes
       character*100 b_envel, btemp
       character*1 qhis, stars
       character*132 bti

       integer nstar(180) 
       integer i_histo(36)

       real x(4000), y(4000), xn(4000), yn(4000), xe(4000), ye(4000)
       real graina(4000), suma(4000), grainl(4000), grl(4000)
       real grainabs(4000), grainbs(4000)

       real x1,x2,x3,y1,y2,y3,dx1,dx2,dy1,dy2,d1,d2
       real pi, pih, pi2, factor, xend
       real hist_max, hmax

       data npopepa,minppp,npa/4000,3,4000/
       data iunit,lenhis,mincr,incr/1,50,36,5/
       data iunit10,iunit2,iunit3,iunit4,ncard,nlist/10,2,3,4,5,6/
       data distmin/1./
       data pi,pih,pi2/3.141596254,1.570796327,6.283185308/
       data factor/0.0174532925/

*---------------------------------------------------------------------72
*------ask file name, etc.

10001  continue
       write(*,1001) minppp,npopepa
1001   format
     .(' -----------------------------------------------------------'/
     . ' ***  ishapes  ***                            2012-03-06, rh'/
     . ' -----------------------------------------------------------'/
     . ' calculates shape factors and angles of polygons'/
     . ' outlines must be closed'/
     . ' deltP=(PE-P)/P  (≠PARIS)'/
     . ' deltA=(AE-A)/A '/
     . ' prints results on screen and in files'/
     . ' minimum number of points per particles = ',i5,/
     . ' maximum number of points per particles = ',i5,/
     . ' number of particles is unlimited...'/
     . ' -----------------------------------------------------------'/
     . ' input file:'/
     . '    line 1:            bti          title (must have)'/
     . '    line 2:            n            total number of points'/
     . '    for each particle: x,y          floating x-y coordinates'/
     . '    |                  ...          ...etc.'/
     . '    |                  Xend,Yend    end coordinates'/
     . ' ----------------------------------------------------------'/
     . 'name of input file:')

       read(*,5003) b_infile
       
       write(nlist,1032)
1032   format
     . ('end coordinate of input file (0, 9999, ... one number): ')
       read(ncard,*) xend
       yend=xend

1      continue

3      continue

       write(*,1006)
1006   format('want results on screen (0), in files (1), or both (2):')
       read(*,*) iprint

       if(iprint.eq.0) write(*,1011)
1011   format(
     .   '-------------------------------------------------------'/
     .   'no output file '/
     .   '-------------------------------------------------------')

       if(iprint.eq.0) go to 2

*---------------------------------------------------------------------72
*------output file name

       b_angles=b_infile
       b_shapes=b_infile
       b_envel=b_infile
       ml=mlen(b_infile)

       ml2=ml+4
       if(ml2.gt.100) print *, 'file name too long'
       if(ml2.gt.100) ml2=100
       ml1=ml2-3

       write(b_angles(ml1:ml2),'(4a)') '.ang'
       write(b_shapes(ml1:ml2),'(4a)') '.shp'
       write(b_envel(ml1:ml2),'(4a)') '.elp'

       write(*,1007) b_angles(1:ml2)
1007   format
     . ('name of output file (angles) ? [',a,'] (return=default) > ')
       read(*,5003) btemp
       if(mlen(btemp).ne.0) b_angles=btemp

       write(*,1018) b_shapes(1:ml2)
1018   format
     . ('name of output file (shapes) ? [',a,'] (return=default) > ')
       read(*,5003) btemp
       if(mlen(btemp).ne.0) b_shapes=btemp

       write(*,1019) b_envel(1:ml2)
1019   format
     . ('name of output file (envelopes) ? [',a,'] (return=def.) > ')
       read(*,5003) btemp
       if(mlen(btemp).ne.0) b_envel=btemp


2      continue

*---------------------------------------------------------------------72

*------open input file

       open(unit=iunit, file=b_infile,status='old',
     .      form='formatted', access='sequential')

       read(iunit,*) bti
       read(iunit,*) nprov
       
       ifinal=0
       ifinale=0


*------print header on screen-------------

       if(iprint.ne.1) write(nlist,5076)
5076   format(
     . '--------'/
     . 'results:'/
     . '--------'/
     . '  #   n(in) n(out)  S/L     L/p     phiL',
     . '     paris','    deltP     deltA'/)

*------open output files-------------

       if(iprint.eq.0) go to 6


*------ang --- all angles-------------
       open(unit=iunit2,file=b_angles,status='new',
     .       form='formatted',access='sequential')

       write(iunit2,5063)
*5063   format(' grain  point  angle  tot.angle  length  rel.length')
5063   format(' grain  point  angle  abs.angle tot.angle  length  ',
     .   'rel.length   both_sides')


*------enl --- coordinates of envelope-------------
       open(unit=iunit10, file=b_envel,status='new',
     .      form='formatted', access='sequential')


*------shp --- shape factors-------------
       open(unit=iunit4,file=b_shapes,status='new',
     .       form='formatted',access='sequential')

       write(iunit4,5066)
5066   format(
     . ' #  xL  xS  xPL  xPS  an1  an2  ',
     . ' peri  area  perie  areae  paris  deltP deltA')

6      continue

*------formats

5000   format(2i5)
5003   format(a)


*---------------------------------------------------------------------72
*------start read

*   icount: counter for total number of coordinates
*   np:     number of coordinates per string before checkclose

       jseg= 1
       icount=0
       ngrain=0

*------start particle------------

500    continue


       call seginp
     .   (iunit,icount,np,x,y,nprov,npopepa,minppp,icont,xend)

*   icont=1: particle too small or too large
*   icont=2: end of coordinate file

       if(icont.eq.1) go to 400
       if(icont.eq.2) go to 501

       ngrain=ngrain+1


*------ particle outlines mujst be closed by scasmoFull  ------------
*
*       call checkclose(x,y,np,xn,yn,npn,mindist,distmin)
*
      ifinal=ifinal+np+1
  

*------determine angles of each particles

*       call angles(xn,yn,npn,graina,suma,grainl,grl)
       call angles(x,y,np,graina,grainabs,suma,grainl,grl,grainbs)


*------determine envelope of each particles

*       call envelope(xn,yn,npn,xe,ye,ne)
       call envelope(x,y,np,xe,ye,ne)

*------close particle envelope------------

       ifinale=ifinale+ne+1
       call perim(xe,ye,ne,perie)
       call parea(xe,ye,ne,areae)


*------determine envelope of each particles

*       call parisetc(xn,yn,npn,xL,xS,xP1,xP2,an1,an2,peri,area,paris)
       call parisetc(x,y,np,xL,xS,xP1,xP2,an1,an2,peri,area,paris)


*------finish particle ------------

       jseg= jseg+ np- 1

*---------------------------------------------------------------------72
*------write output to screen-------------

       if(iprint.eq.1) go to 4

       rat=xS/xL
       asp=xL/xP1
       deltA=100*((areae-area)/area)   !!!!!!!!!
       deltP=100*((peri-perie)/peri)   !!!!!!! NEW  ≠ PARIS/2

       write(nlist,5060) 
     . ngrain, np,np,rat,asp,an1,paris,deltP,deltA
5060   format(3i5,2f9.3,f7.0,3f9.2)

4      continue


*---------------------------------------------------------------------72
*------write file-------------

       if (iprint.eq.0)  go to 5

*-----------------write only 2 to np   => first point only as last ----

       write(iunit2,5062) 
*     . (ngrain,i,graina(i),suma(i),grainl(i),grl(i),i=1,np-1)
*     . (ngrain,(i-1),graina(i),suma(i),grainl(i),grl(i),i=2,np-1)
     . (ngrain,(i-1),graina(i),grainabs(i),suma(i),grainl(i),
     . grl(i),grainbs(i),i=2,np-1)
5062   format(2i5,6f12.5)

       write(iunit2,5064) 
*     . ngrain,np,graina(np),suma(np),grainl(np),grl(np)
     . ngrain,(np-1),graina(np),grainabs(np),suma(np),grainl(np),
     . grl(np),grainbs(np)
5064   format(2i5,6f12.5)

       write(iunit2,5065)
5065   format(' ')

       write(iunit10,5068) (xe(i),ye(i),i=1,ne)
       write(iunit10,5068) xend,xend
5068   format(2f20.5)

       write(iunit4,5067) 
     . ngrain,xL,xS,xP1,xP2,an1,an2,peri,area,perie,areae,
     . paris,deltP,deltA
5067   format(i5,4f9.3, 2f7.0, f9.3, e12.4, f9.3, e12.4, 3f9.2)

5      continue


*------end particle--------------

400    np=1
       go to 500

501    continue


*------segmented input: end

       close(unit=iunit)
       close(unit=iunit2)
*       close(unit=iunit3)
       close(unit=iunit4)
       close(unit=iunit10)

       if (iprint.eq.0)  go to 55


*------enl --- coordinates of envelope-------------
       open(unit=iunit10, file=b_envel,status='old',
     .      form='formatted', access='sequential')

       do i=1,ifinale
       read(iunit10,*)  x(i), y(i)
       enddo
       close(unit=iunit10)

       open(unit=iunit10, file=b_envel,status='old',
     .      form='formatted', access='sequential')
       write(iunit10,*) bti
       write(iunit10,5070) ifinale
       do i=1,ifinale
       write(iunit10,5068)  x(i), y(i)
       enddo
       close(unit=iunit10)

5070   format(i8)

*---------------------------------------------------------------------72
*------end


       write(nlist,5080) ngrain,nprov
5080   format(/'file with ',i4,' grains (',i5,' points) evaluated'/)
     
       write(nlist,1008) b_angles(1:ml2), b_shapes(1:ml2),
     .               b_envel(1:ml2)
1008   format(
     .   '-------------------------------------------------------'/
     .   'output files: '/
     .    ' - ',a/' - ',a/' - ',a/
     .   '-------------------------------------------------------')

55     continue
       if(iprint.eq.0) write(*,1011)
       print *,'(screen output is not saved)'
       print *,' '

       end


*=============================================================
*   subroutine seginp
*
       subroutine seginp(iuni2,i,np,x,y,nprov,mxsize,minppp,icont,xend)
*
*   iuni1  (i)   unit number of terminal
*   iuni2  (i)   unit number of file
*   i      (i/o) counter of total no.of coordinate points
*                at start, set i=0
*   np     (  o) counter of no.of points per particle
*   x      (  o) x-coordinates
*   y      (  o) y-coordinates
*   nprov  (i  ) total no.of coordinate points
*   mxsize (i  ) max.no.of points per particle
*   minppp  (i  ) minimum no.of points per particle
*   icont  (  o) flag for termination of seginp
*   xend   (i  ) terminator coordinate
*
       dimension x(1),y(1)
       icont=0
       np=1
*
*   start reading coordinates of one particle
*
1      continue
       i=i+1
       if(i.le.nprov) go to 300
       icont= 2
       go to 9999
300    continue
       read(iuni2,*) xx,yy
       if(xx.eq.xend) go to 400
       x(np)= xx
       y(np)= yy
       np= np+1
       if(np.gt.mxsize) go to 998
       go to 1
*
*   points of one particle are collected
*
400    np=np-1
       if(np.le.minppp) go to 999
       go to 9999
*
*   particle too large
*
998    continue
       print *,' particle with too many points discarded'
*
*    read remaining coordinates of particle
*
600    continue
       i=i+1
       read(iuni2,*,end=601) xx,yy
       if(xx.ne.xend) go to 600
601    continue
       icont= 1
       go to 9999
*
*   particle too small
*
999    continue
       if(np.lt.1) go to 700
       write(iuni1,1002)
1002   format(' particle with too few points discarded')
700    continue
       icont= 1
9999   continue
       return
       end


*=============================================================
*   subroutine angles
*
*    x(np),y(np) come in - x(np)=x(1)  and y(np)=y(1)
*    (np-1) corners and segments are evaluated
*    a(np-1)  angles   (-180 < angle < +180)
*    xl(np-1) segment length (looking forward
*    angle is defined as 0 if p1 p2 p3 are colinear
*    turning left or right is positive or negative

       subroutine angles(x,y,np,a,aabs,as,xl,xlr,bs)

       dimension x(1),y(1),a(1),aabs(1),as(1),xl(1),xlr(1),bs(1)

*------start with x1y1 x2y2 x3y3  -> pt1 where x1y1 = pt0 = ptn

       s=0
       angsum=0
       a(1)=0.
       as(1)=0.
       xl(1)=0.

       do 200 i1=1,np-2

       i2= i1+1
       i3= i1+2
       
       ic=i1+1

       x1= x(i2)-x(i1)
       x2= x(i3)-x(i2)
       y1= y(i2)-y(i1)
       y2= y(i3)-y(i2)
       d1= sqrt(x1*x1 + y1*y1)
       d2= sqrt(x2*x2 + y2*y2)
       cos= (x1*x2 + y1*y2)/(d1*d2)
       if(cos.gt.1.) cos=1.
       if(cos.lt.-1.) cos=-1.
       z= x1*y2 - x2*y1

       a(ic)= 57.29578*acos(cos)   
       if(z.lt.0) a(ic)=-a(ic)
       aabs(ic)=  abs(a(ic))
       angsum=angsum+a(ic)
       
       s=s+d1
       xl(ic)=s
       as(ic)=angsum
       
200    continue


*------last segment

       i1= np-1
       i2= np         ! assuming that point(n)=point(1)  x(n)=x(1)
       i3= 2

       ic=np

       x1= x(i2)-x(i1)
       x2= x(i3)-x(i2)
       y1= y(i2)-y(i1)
       y2= y(i3)-y(i2)
       d1= sqrt(x1*x1 + y1*y1)
       d2= sqrt(x2*x2 + y2*y2)
       cos= (x1*x2 + y1*y2)/(d1*d2)
       if(cos.gt.1.) cos=1.
       if(cos.lt.-1.) cos=-1.
       z= x1*y2 - x2*y1

       a(ic)= 57.29578*acos(cos)   
       if(z.lt.0) a(ic)=-a(ic)
       aabs(ic)=  abs(a(ic))
       angsum=angsum+a(ic)


       s=s+d1
       xl(ic)=s
       as(ic)=angsum

       if(angsum.lt.0.) then
       do i=1,np
       as(i)=-as(i)
       a(i)=-a(i)
       enddo
       endif

       do i=1,np
       xlr(i)=xl(i)/xl(np)
       enddo
       
*   ------- do both sides -------

       do i=2,np-1
       ip1=i+1
       im1=i-1
       bs(i)=xlr(ip1)-xlr(im1)
       enddo
       
*   first and last

       ii=2
       bs(1)=xlr(ii)   !  since xl(0) = 0
       bs(np)=1+xlr(ii)-xlr(np-1)


*    fin max and normalize
       xxbs=-1.
       do i= 1,np
       xxbs=amax1(xxbs,bs(i))
       enddo

       do i= 1,np
       bs(i)=bs(i)/xxbs
       enddo


       return
       end


*=============================================================
*   subroutine envelope (xin,yin,nin,xout,yout,nout)

*   finds convex hull
*   by rotating all points of outline through 360 deg. (1 deg. interval)
*   and determining the max x coordinate of the outline in each orientation
*   all points that never reach the max x value are eliminated from the outline
*   the convex hull has a maximum of 360 points
*   360+1 if the contour is closed

       subroutine envelope(xin,yin,nin,xout,yout,nout)
   
       dimension xin(1), yin(1), xout(1), yout(1)
       dimension r(3000), ang(3000), ncor(3000), xrot(3000)
       data pi,piha,pi2,factor/3.141596254,1.570796327,6.283185308,
     .       0.0174532925/


       do 10 i=1,nin
       
       r(i)= sqrt(xin(i)*xin(i) + yin(i)*yin(i))
       
       bet=piha
       if(xin(i).ne.0.) bet= atan(yin(i)/xin(i))
       if(xin(i).lt.0.) bet= bet+pi
       if(bet.lt.0.)  bet= bet+ pi2
       ang(i)= bet
       
10     continue


       do 1000 j=1,360
       kount=j
       
       do 200 i=1,nin
       xrot(i)= r(i)*cos(ang(i)+float(j-1)*factor)
200    continue

       xmax= -999999.

       do 201 i=1,nin
       xmax=amax1(xmax,xrot(i))
201    continue

       do 202 i=1,nin
       if(xrot(i).eq.xmax) ncor(kount)=i
202    continue

1000   continue
       
*   ncor(j) lists the coordinate number i of the outline that is at x max for each rotation j
*   some coordinates i are never at the max position
*   some coordinates i are at the max position for more than one angle j
*   only those points i that figure in the ncor(j) list are used - and they are used only once
*   duplicates are eliminated

       xout(1)=xin(ncor(1))
       yout(1)=yin(ncor(1))
       nout=1
       
       do 500 j=2,360
       if(ncor(j).eq.ncor(j-1)) go to 500
       nout=nout+1
       xout(nout)=xin(ncor(j))
       yout(nout)=yin(ncor(j))
       
500    continue
       if(xout(nout).eq.xout(1).and.yout(nout).eq.yout(1)) go to 600
       nout=nout+1
       xout(nout)=xout(1)
       yout(nout)=yout(1)
 
 600   continue
       return
       end


*=============================================================
*   subroutine parisetc
*
       subroutine parisetc(x,y,n,xL,xS,xP1,xP2,an1,an2,peri,area,paris)

       dimension x(1),y(1),xa(180),xb(180)
       incr=1
       mincr=180/incr

*------determine simple projection of string

       call bproj(x,y,n,xb,incr,xL,xS,xP1,xP2,an1,an2)

*------determine projection of each segment

       call aproj(x,y,n,xa,incr)

*------distances between coordinate points => perimeter

       call perim(x,y,n,peri)

*------sum of triangles => area

       call parea(x,y,n,area)
       requ=  0.5*sqrt(area/3.14159)

*------calculate paris

       sa2b=0.
       sxb=0.

       do 200 i=1,mincr
       a2b  = xa(i)-2*xb(i)
       sa2b = sa2b + a2b
       sxb  = sxb  + xb(i)
200    continue

*------paris factors

       paris = 100.*sa2b/sxb

       return
       end


*=============================================================
*   subroutine bproj
*
       subroutine bproj(x,y,nx,proj,incr,axlo,axsh,axp1,axp2,an1,an2)
   
*   calculates longest, shortest axis and axis perpendicular to
*   long axis -  evaluates angle of long axis.

       dimension x(1), y(1), proj(1), r(3000)
       data pi,piha,pi2,factor/3.141596254,1.570796327,6.283185308,
     .       0.0174532925/

       do 240 i=1,nx
       r(i)= sqrt(x(i)*x(i) + y(i)*y(i))
240    continue
       mincr=180/incr
       do 250 j=1,mincr
       xpmin= 999999.
       xpmax=-xpmin
       do 230 i=1,nx
       bet=piha
       if(x(i).ne.0.) bet= atan(y(i)/x(i))
       if(x(i).lt.0.) bet= bet+pi
       if(bet.lt.0.)  bet= bet+ pi2
       beta= bet + float(j*incr)*factor
       xp= r(i)*cos(beta)
       xpmin= amin1(xpmin,xp)
       xpmax= amax1(xpmax,xp)

230    continue

       proj(j)= xpmax- xpmin
       
250    continue
       axlo= -999999.
       axsh= -axlo
       
       do 300 imi=1,mincr
       i= imi
       axlo= amax1(axlo,proj(i))
       axsh= amin1(axsh,proj(i))
300    continue

       do 301 li= 1,mincr
       if(axlo.ne.proj(li)) go to 301
       ilong= li
       an1= 180.-float(ilong*incr)
       if(an1.lt.0.) an1 = an1+180.
301    continue

       ih= 90/incr
       if(ilong.gt.ih)  ih= -ih
       i90= ilong+ih
       axp1= proj(i90)

       do 302 li= 1,mincr
       if(axsh.ne.proj(li)) go to 302
       ilong= li
       an2= 90.-float(ilong*incr)
       if(an2.lt.0.) an2 = an2+180.
302    continue

       ih= 90/incr
       if(ilong.gt.ih)  ih= -ih
       i90= ilong+ih
       axp2= proj(i90)
       return
       end




*=============================================================
*   subroutine aproj
*
       subroutine aproj(x,y,np,xproj,incr)
       dimension xproj(1),x(1),y(1)
       data pi,pih,pi2,factor/3.141596254,1.570796327,6.283185308,
     .       0.0174532925/
       mincr= 180/incr
       do 190 i=1,mincr
       xproj(i)= 0.
190    continue
       do 200 i1=1,np-1
       i2= i1+1
*
*    distance between coordinates
*
       yn= y(i2)-y(i1)
       xn= x(i2)-x(i1)
       s= sqrt(xn*xn+yn*yn)
*
*   projections
*
       phi= pih
       if(xn.ne.0) phi= atan(yn/xn)
       do 202 j=1,mincr
       alph= phi + float(j*incr)*factor
       xproj(j)= xproj(j) + abs(s* cos(alph))
202    continue
200    continue
       return
       end



*=============================================================
*   subroutine parea

       subroutine parea(x,y,np,area)
       dimension x(1),y(1)
       area=0.
       do 200 i1=2,np-1
       i2= i1+1
       x1= x(i1)-x(1)
       x2= x(i2)-x(i1)
       y1= y(i1)-y(1)
       y2= y(i2)-y(i1)
       z= x1*y2 - x2*y1
       area= area+z
200    continue
       area= .5*abs(area)
       return
       end

*=============================================================
*   subroutine perim

       subroutine perim(x,y,np,peri)
       dimension x(1),y(1)
       peri=0.
       do 200 i1=1,np-1
       i2= i1+1
       yn= y(i2)-y(i1)
       xn= x(i2)-x(i1)
       s= sqrt(xn*xn+yn*yn)
       peri=peri+s
200    continue
       return
       end


*=============================================================
       integer function mlen(s)

*      determine actual length of string s

       character *(*) s
       l=len(s)
       do 10 k=l,1,-1
       lg=k
       ivalue=ichar(s(k:k))
       if(.not.(ivalue.eq.32.or.ivalue.eq.0)) goto 99
   10  continue
       lg=0
   99  mlen=lg
       return
       end

